@extends('layouts.app')
@section('pageTitle', 'Clients')
@section('content')

<?php use App\Http\Controllers\ConfigController; ?>
	<div class="container">
	
		<div class="card">
			<div class="card-header">Clients @if(ConfigController::check_privilege('ACCESS_ADD_CLIENT'))<span class="float-right"><span class="btn btn-sm btn-primary" data-toggle="modal" data-target="#modal-add">Add</span></span>@endif</div>
			<div class="card-body" id="clients-data">
	          	<div id="loader-wrapper" style="display: none;">
                	<div id="loader"></div>
              	</div>
				@include('clients.data')
			</div>
			
		</div>
	
	</div>
	@if(ConfigController::check_privilege('ACCESS_ADD_CLIENT'))
		@include('clients.add')
	@endif

	@if(ConfigController::check_privilege('ACCESS_EDIT_CLIENT'))
		@include('clients.edit')
	@endif

	@if(ConfigController::check_privilege('ACCESS_DELETE_CLIENT'))
		@include('clients.delete')
	@endif	

	@if(ConfigController::check_privilege('ACCESS_RESTORE_CLIENT'))
		@include('clients.restore')
	@endif	

	<script>
		function client_list_refresh(){
			$.ajax({
				type:'get',
				url: '{{url("client.list")}}',
				data:{},
				success:function(data){
					if(data.html){
						$('#clients-data').html(data.html);
					}
				},
				error:function(data){
					alert('Something went wrong');
				}
			});
		}

		function loader_start(){
			$('#loader-wrapper').fadeIn('slow');
		}

		function loader_stop(){
			$('#loader-wrapper').fadeOut('slow');
		}
	</script>
@endsection