<br>
<?php use App\Http\Controllers\ConfigController; ?>

<div class="col-md-12">
	<div class="card">
		<div class="card-header"></div>
		<div class="card-body" id="invoices-data">
				@if(count($invoices) > 0)
					<div class="table table-striped table-inverse table-hover table-bordered table-sm table-responsive">
					<table class="table " style="font-size: 12px;">

						<thead class="thead-dark">
							<tr>
								<th>ID</th>
								<th>Business Name</th>
								<th>Invoice Type</th>
								<th>Transaction Type</th>
								<th>Updated at</th>
								<th>Status</th>
								<th>Balance</th>
								<th>Total Amount</th>
								<th></th>
								<th></th>
							</tr>
						</thead>
						<tbody>
							@foreach($invoices as $invoice)
							<tr @if($invoice->deleted_at <> '') class="bg-danger text-white" @endif @if($invoice->frcs_verified =='x') class="bg-warning text-white" title="Invoice on DOUBT status. Please check on VMS if this invoice has been created." @endif>
								<td>{{$invoice->uuid}}</td>
								<td>{{ConfigController::get_clientname($invoice->client_id)}}</td>
								<td>{{ucfirst($invoice->invoice_type)}}</td>
								<td>{{ucfirst($invoice->transaction_type)}}</td>
								<td>{{$invoice->updated_at}}</td>
								<td>{{ConfigController::print_invoice_status($invoice->status)}}</td>
								<td>{{ConfigController::get_invoice_balance($invoice->id)}}</td>
								<td>{{$invoice->total_amount}}</td>
								<td><a href="{{url('invoice.view')}}.{{$invoice->uuid}}" class="btn btn-sm btn-info"><i class="fa fa-eye"></i></a></td>
								@if($invoice->frcs_verified == '1')
								<td><a href="{{url('invoice.pdf.view')}}.{{$invoice->uuid}}" class="btn btn-sm btn-danger"><i class="fas fa-file-pdf"></i></a></td>
								@else
								<td>
									@if(ConfigController::check_privilege('ACCESS_UNLOCK_INVOICE'))
										<a href="{{url('invoice.unlock')}}.{{$invoice->uuid}}" class="btn btn-sm btn-warning"><i class="fas fa-unlock"></i>
										</a>
									@endif
								</td>
								@endif

							</tr>
							@endforeach
						</tbody>
					</table>
					</div>
				
				@else
					<div class="alert alert-warning text-center">No Records Found</div>
				@endif
		</div>
	</div>
</div>


<script type="text/javascript">
	function load_invoice(){
		$.ajax({
			type:'post',
			url: "{{url('invoice.client.load')}}",
			data:{'_token': $('input[name=_token]').val(), 'client_id':'{{$id}}'},
			beforeSend:function(){
				loader();
			},
			success:function(data){
				stop_loader();
				if(data.html)
				{
					$('#invoices-data').html(data.html);
					
				}		
			},
			error:function(data){
				stop_loader();	

				swal({
	  				type:'error',
	  				title: 'Error occured',
	  				text: 'Oops, Something went wrong. Please contact admin.',
	  				animation:true
	  			});
			}
		});	
	}


	function display_frcs(id){
		  if(document.getElementById("toggle_"+id).value=="y")
		  {
		  	$('#display_frcs'+id).fadeOut('slow');
		   	document.getElementById("toggle_"+id).value="n";
		  }
		  else
		  {
		  	$('#display_frcs'+id).fadeIn('slow');
		    document.getElementById("toggle_"+id).value="y";
		  }
	}
</script>

