  <!-- The Modal -->
  <div class="modal fade" id="modal-delete">
    <div class="modal-dialog">
      <div class="modal-content">
      
        <!-- Modal Header -->
        <div class="modal-header">
          <h4 class="modal-title">Delete Client</h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        <input type="hidden" id="delete_id">
        <!-- Modal body -->
        <div class="modal-body">
            <div>Do you wish to remove Client id <span id='param'></span>?</div>
        </div>
        
        <!-- Modal footer -->
        <div class="modal-footer">
          <button type="submit" class="btn btn-danger" id="submit-delete">Remove</button>
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
        
      </div>
    </div>
  </div>
  
</div>

<script type="text/javascript">
  $(document).ready(function(){
    $('#submit-delete').on('click',function(){
      $.ajax({
        type:"post",
        url:"{{url('client.delete')}}",
        data:{
            '_token': $('input[name=_token]').val(),
            'id': $('#delete_id').val() 
        },
        beforeSend:function(data){
            $('#delete_alert').removeClass('alert-success');
            $('#delete_alert').removeClass('alert-danger');
            $('#delete_alert').fadeOut('slow');

        },
        success:function(data){
          if(data.success)
          {
            $('#delete_alert').addClass('alert-success');
            $('#delete_alert').fadeIn('slow');
            $('#delete_alert').html(data.success);
            loader_start();
            swal({
              type:'success',
              title: 'Done',
              text: 'Removed successfully'
            });
            client_list_refresh();

            setTimeout(function() {
              loader_stop();
              $('#modal-delete').modal('hide');
            }, 4000);
          }

          if(data.error)
          {
            $('#delete_alert').addClass('alert-danger');
            $('#delete_alert').fadeIn('slow');
            $('#delete_alert').html(data.error);
          }
        },
        error:function(data){

          var obj = jQuery.parseJSON(data.responseText) ;
          var errors = obj.errors;

          if(obj.message)
          {
            $('#delete_alert').addClass('alert-danger');
            $('#delete_alert').fadeIn('slow');
            $('#delete_alert').html(obj.message);
          }

        }
      });
    });//end AJAX edit 

  });//end ready doc


  $(document).on('click', '.delete-modal', function() {
      $('#delete_id').val($(this).data('id'));
      $('#param').text($(this).data('id'));

      $('#modal-delete').modal('show');
  });
</script>