<?php use App\Http\Controllers\ConfigController; ?>
@if(count($clients) > 0)
	<table class="table table-striped table-inverse table-hover table-bordered table-sm" style="font-size: 12px;">

		<thead class="thead-dark">
			<tr>
				<th>ID</th>
				<th>Business Name</th>
				<th>Address</th>
				<th>Phone Contact</th>
				<th>Email</th>
				<th>Tin Number</th>
				<th>Contact Name</th>
				@if(ConfigController::check_privilege('ACCESS_EDIT_CLIENT'))
					<th></th>
				@endif

				@if(ConfigController::check_privilege('ACCESS_DELETE_CLIENT'))
					<th></th>
				@endif
				<th></th>
			</tr>
		</thead>
		<tbody>
			@foreach($clients as $client)
			<tr @if($client->deleted_at <> '') class="bg-danger text-white" @endif>
				<td>{{$client->id}}</td>
				<td>{{ucfirst($client->business_name)}}</td>
				<td>{{$client->address}}</td>
				<td>{{$client->phone_contact}}</td>
				<td>{{$client->email}}</td>
				<td>{{$client->tin_number}}</td>
				<td>{{$client->contact_name}}</td>
				@if($client->deleted_at == '')
					@if(ConfigController::check_privilege('ACCESS_EDIT_CLIENT'))
						<td><button class="btn btn-sm btn-secondary edit-modal"
								data-id="{{$client->id}}"
								data-business_name="{{$client->business_name}}"
								data-address="{{$client->address}}"
								data-phone_contact="{{$client->phone_contact}}"
								data-email="{{$client->email}}"
								data-tin_number="{{$client->tin_number}}"
								data-contact_name="{{$client->contact_name}}"
							>
								<span class="fa fa-edit"></span>
							</button>
						</td>
					@endif

					@if(ConfigController::check_privilege('ACCESS_DELETE_CLIENT'))
						<td><button class="btn btn-sm btn-danger delete-modal"
								data-id="{{$client->id}}">
								<span class="fa fa-trash"></span>
							</button>
						</td>
					@endif
				@endif

				@if($client->deleted_at <> '')
					<td colspan="2" class="text-center">
						@if(ConfigController::check_privilege('ACCESS_RESTORE_CLIENT'))
						<button class="btn btn-sm btn-success restore-modal" title="Restore" 
							data-id="{{$client->id}}">
							<i class="fab fa-creative-commons-sa"></i>
						</button>
						@endif
					</td>
				@endif

				<td><a href="{{url('client.detail')}}.{{$client->id}}" class="btn btn-primary btn-sm">
					<span class="fa fa-eye"></span></a>
				</td>

			</tr>
			@endforeach
		</tbody>
	</table>
@else
	<div class="alert alert-warning text-center">No Records Found</div>
@endif




