@extends('layouts.app')
@section('pageTitle','Restore')
@section('content')
<?php use App\Http\Controllers\ConfigController; ?>

	<div class="offset-2 col-md-8">
		<div class="card">
			<div class="card-header"><a class="btn btn-sm btn-link btn-spacer" title="Back" href="{{url('brand.list')}}"><i class="fa fa-chevron-left"></i></a> Brands</div>
				<div class="card-body">
					@include('brands.restore_data')
				</div>
					
		</div>
	</div>


<!--modal-->
	<div id="myModal" class="modal fade" role="dialog">
		<div class="modal-dialog">
			<!-- Modal content-->
			<div class="modal-content">
				<div class="modal-header" id="modal-heading">
					<button type="button" class="close" data-dismiss="modal">&times;</button>
					<h4 class="modal-title"></h4>
				</div>
				<div class="modal-body">

					<div class="deleteContent">
						Are you Sure you want to restore <span class="dname"></span> ? <span
							class="hidden did"></span>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn actionBtn" id="actionBtn">
							<span id="footer_action_button" class='fa'> </span>
						</button>
						<button type="button" class="btn btn-warning" data-dismiss="modal">
							<span class='fa fa-remove'></span> Close
						</button>
					</div>
				</div>
			</div>
		</div>
	</div>
<script type="text/javascript">
	//trigger RESET modal to Pop up
    $(document).on('click', '.restore-modal', function() {
        $('#footer_action_button').text(" Restore");
        $('#footer_action_button').removeClass('fa-check');
        $('#footer_action_button').addClass('fa-refresh');
        $('.actionBtn').removeClass('btn-success');
        $('.actionBtn').addClass('btn-primary');
        $('.actionBtn').addClass('restore-brand');
        $('.modal-title').text('Restore');
        $('.did').text($(this).data('id'));
        $('.deleteContent').show();
        $('.dname').html($(this).data('name'));
        $('#myModal').modal('show');
    });



    $(document).on('click', '.restore-brand', function() {
        $.ajax({
            type: 'post',
            url: "{{url('/brand.restore')}}",
            data: {
                '_token': $('input[name=_token]').val(),
                'id': $('.did').text()
            },
            beforeSend:function(){
            	$('.restore-brand').addClass('loading');
            },
            success: function(data) {

                @if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                    console.log(data);
                @endif      

            	$('.restore-brand').removeClass('loading');
            	$('#footer_action_button').text(" Done");
            	$('#footer_action_button').removeClass('fa-refresh');
            	$('#footer_action_button').addClass('fa-check');
            	$('.actionBtn').removeClass('btn-primary');
            	$('.actionBtn').addClass('btn-success');

                $('.item' + $('.did').text()).remove();

                setTimeout(function(){
                	$('#myModal').modal('hide');
                },3000)

            },
            error:function(data){
                @if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                    console.log(data.responseText);
                @endif      
            }
        });
    });

</script>


@endsection