<?php use App\Http\Controllers\ConfigController; ?>
@if(count($brands) > '0')
	<div class="table-responsive">
		<table class="table table-striped table-bordered  table-hover">
			<thead class="table-heading">
				<th>ID</th>
				<th>Name</th>
				<th>Description</th>
				<th>Created By</th>
				<th>Updated By</th>
				<th>Updated At</th>
				<th></th>
			</thead>
			<tbody>
			
				@foreach($brands as $brand)
					<tr class="item{{$brand->id}}">
						<td>{{$brand->id}}</td>
						<td>{{$brand->name}}</td>
						<td>{!! nl2br($brand->description) !!}</td>
						<td>{{ConfigController::get_username($brand->created_by)}}</td>
						<td>{{ConfigController::get_username($brand->updated_by)}}</td>
						<td>{{$brand->updated_at}}</td>
						<td><a  class="btn btn-primary restore-modal" data-id="{{$brand->id}}" data-name="{{$brand->name}}" title="Restore Brand"><span class="fa fa-refresh"></span></a></td>	
					</tr>
				@endforeach
			
			</tbody>
		</table>
	</div>
@else
	<div class="alert alert-warning">
		<div>Sorry, no result found.</div>
	</div>
@endif

