@extends('layouts.app')
@section('pageTitle','Brands')
@section('content')
<?php use App\Http\Controllers\ConfigController; ?>

	@if(ConfigController::check_privilege('ACCESS_SEARCH_BRAND'))
		<div class="container">
			<div class="card">
				<div class="card-header">Search <div class="float-right">@if(ConfigController::check_privilege('ACCESS_RESTORE_BRAND'))<a href="{{url('/brand.restore')}}" class="btn btn-primary btn-sm"><i class="fa fa-refresh"></i> Restore Brand</a>@endif @if(ConfigController::check_privilege('ACCESS_ADD_BRAND'))<a href="{{url('/brand.add')}}" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> Brand</a>@endif</div></div>
				<div class="card-body">
					<form class="form-horizontal" method="get" action="{{url('/brand.search')}}">
						<div class="form-group row">
							<div class="col-md-offset-2 col-md-8">
								<input type="text" name="name" placeholder="Please Enter Brand Name" class="form-control">
							</div>
							
						</div>

						<div class="form-group">
							<div class="col-md-offset-8 col-md-2">
								<button type="submit" class="btn btn-primary col-md-12">
									Search
								</button>
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	@endif

<br>
	<div class="container">
		<div class="card">
			<div class="card-header">Brands</div>
				<div class="card-body">
					@include('brands.brand_data')
				</div>
					
		</div>
	</div>


<!--modal-->
	<div id="myModal" class="modal fade" role="dialog">
		<div class="modal-dialog">
			<!-- Modal content-->
			<div class="modal-content">
				<div class="modal-header" id="modal-heading">
					<button type="button" class="close" data-dismiss="modal">&times;</button>
					<h4 class="modal-title"></h4>
				</div>
				<div class="modal-body">

					<div class="deleteContent">
						Are you sure you want to remove <span class="dname"></span> ? <span
							class="hidden did"></span>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn actionBtn" id="actionBtn">
							<span id="footer_action_button" class='fa'> </span>
						</button>
						<button type="button" class="btn btn-warning" data-dismiss="modal">
							<span class='fa fa-remove'></span> Close
						</button>
					</div>
				</div>
			</div>
		</div>
	</div>
	
<script type="text/javascript">
	//trigger RESET modal to Pop up
    $(document).on('click', '.delete-modal', function() {
        $('#footer_action_button').text(" Delete");
        $('#footer_action_button').removeClass('fa-check');
        $('#footer_action_button').addClass('fa-trash');
        $('.actionBtn').removeClass('btn-success');
        $('.actionBtn').addClass('btn-danger');
        $('.actionBtn').addClass('delete-brand');
        $('.modal-title').text('Delete');
        $('.did').text($(this).data('id'));
        $('.deleteContent').show();
        $('.dname').html($(this).data('name'));
        $('#myModal').modal('show');
    });



    $(document).on('click', '.delete-brand', function() {
        $.ajax({
            type: 'post',
            url: "{{url('/brand.delete')}}",
            data: {
                '_token': $('input[name=_token]').val(),
                'id': $('.did').text()
            },
            beforeSend:function(){
            	$('.delete-brand').addClass('loading');
            },
            success: function(data) {
            	@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                	console.log(data);
                @endif

            	$('.delete-brand').removeClass('loading');
            	$('#footer_action_button').text(" Done");
            	$('#footer_action_button').removeClass('fa-trash');
            	$('#footer_action_button').addClass('fa-check');
            	$('.actionBtn').removeClass('btn-danger');
            	$('.actionBtn').addClass('btn-success');

                $('.item' + $('.did').text()).remove();

                setTimeout(function(){
                	$('#myModal').modal('hide');
                },3000);

            },
            error:function(data){
            	@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                	console.log(data.responseText);
                @endif            	

            }
        });
    });

</script>


@endsection