<?php use App\Http\Controllers\ConfigController; ?>
@if(count($brands)>'0')
	<div class="table-responsive">
		<table class="table table-striped table-bordered  table-hover table-sm">
			<thead class="table-heading bg-secondary text-white">
				<th>ID</th>
				<th>Name</th>
				<th>Desc</th>
				<th>Created By</th>
				<th>Updated By</th>
				<th>Updated At</th>
				@if(ConfigController::check_privilege('ACCESS_EDIT_BRAND'))
					<th></th>
				@endif

				@if(ConfigController::check_privilege('ACCESS_DELETE_BRAND'))
					<th></th>
				@endif
			</thead>
			<tbody>
			
				@foreach($brands as $brand)
					<tr class="item{{$brand->id}}">
						<td>{{$brand->id}}</td>
						<td>{{$brand->name}}</td>
						<td>{!! $brand->description !!}</td>
						<td>{{ConfigController::get_username($brand->created_by)}}</td>
						<td>{{ConfigController::get_username($brand->updated_by)}}</td>
						<td>{{$brand->updated_at}}</td>
						@if(ConfigController::check_privilege('ACCESS_EDIT_BRAND'))
							<td><a href="{{url('/brand.edit')}}.{{$brand->id}}" class="btn btn-primary" title="Edit Brand"><span class="fa fa-edit"></span></a></td>		
						@endif		

						@if(ConfigController::check_privilege('ACCESS_DELETE_BRAND'))
							<td><a  class="btn btn-danger delete-modal" data-id="{{$brand->id}}" data-name="{{$brand->name}}" title="Delete Brand"><span class="fa fa-trash"></span></a></td>		
						@endif		
					</tr>
				@endforeach
			
			</tbody>
		</table>
	</div>
@else
	<div class="alert alert-warning">
		<div>Sorry, no result found.</div>
	</div>
@endif

