@extends('layouts.app')
@section('pageTitle', 'Add Brand')
@section('content')
<?php use App\Http\Controllers\ConfigController; ?>
<div class="container">
    <div class="row">
        <div class="col-md-8 offset-2">
		<div class="card" id="form_style">
			<div class="card-header"><a class="btn btn-sm btn-link btn-spacer" title="Back" href="{{url('brand.list')}}"><i class="fa fa-chevron-left"></i></a> Add Brand</div>
                <div class="card-body">
                
                <div class="alert alert-success offset-2 col-md-8" id="alert" style="display: none;">
					<div id="alert_message"></div>
				</div>

                    <form class="form-horizontal" method="POST" action="{{url('/brand.add.save')}}" id="brandAdd">
                        {{ csrf_field() }}


                        <div class="form-group row" id="div-name">
                            <label for="name" class="offset-2 control-label col-md-2 control-label-sm">Name</label>

                            <div class="col-md-6">
                                <input id="name" type="text" class="form-control form-control-sm" name="name">
                                        <strong id="error_name"></strong> 
                            </div>
                        </div>


                        <div class="form-group row" id="div-description">
                            <label for="description" class="offset-2 col-md-2 control-label control-label-sm">Description</label>

                            <div class="col-md-6">
                                <textarea class="form-control form-control-sm" name="description" id="description"></textarea>
                                <strong id="error_description"></strong>
                                
                            </div>
                        </div>


                        <div class="form-group">
                            <div class="col-md-2 offset-9">
                                <button type="submit" class="btn btn-primary" id="submit">
                                    <i class="fa fa-plus"></i>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
	$(document).ready(function(){
		$('#brandAdd').submit(function(e){
			e.preventDefault();

			var url,formData;

			url = $(this).attr('action');
			formData = $('#brandAdd').serialize();

			$.ajax({
				type:'post',
				data:formData,
				url:url,
				beforeSend:function(){
					$('#submit').addClass('loading');

					$('#alert').fadeOut('slow');
					$('#alert_message').html('');
					
					$('#name').removeClass('is-invalid');
					$('#description').removeClass('is-invalid');

				},
				success:function(data){
					@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
	                	console.log(data);
	                @endif

					$('#submit').removeClass('loading');
					
					if(data.message){
						$('#alert').fadeIn('slow');
						$('#alert_message').html(data.message);
					}
				},
				error:function(data){
	            	@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
	                	console.log(data.responseText);
	                @endif

					$('#submit').removeClass('loading');					
					
					var obj = jQuery.parseJSON(data.responseText);
					var errors = obj.errors;

					
					if(errors.name){
						$('#name').addClass('is-invalid');
						$('#error_name').addClass('invalid-feedback');
						$('#error_name').html(errors.name);
					}

					
					if(errors.description){
						$('#description').addClass('is-invalid');
						$('#error_description').addClass('invalid-feedback');
						$('#error_description').html(errors.description);
					}
				}
			});
		});

	});
</script>
@endsection