#Version 3.0.0
---

- [Overview](#section-1)
- [Privileges](#section-2)
- [Views](#section-3)
- [Routes](#section-4)
- [Controllers](#section-5)


<a name="section-1"></a>
##Overview
This version allows user to view data of all the staffs that are in his/her group. This access is usually given to group admins
<br><br>

<a name="section-2"></a>
##Privileges
Privileges used are as follows:<br>
<b>ACCESS_GROUP_VIEW </b>- Access to view group tasks.


<a name="section-3"></a>
##Views
Go to `layouts/app.php` and edit below codes:
```php 
      @@if(ConfigController::check_privilege('ACCESS_GROUP_VIEW'))
      <li role="presentation" @@if(Request::is('task.group.view'))class="active"@@endif><a href="@{{url('/task.group.view')}}">Group View</a></li>  
      @@endif
```
<br><br>
Now create a file inside `resources/views/tasks` named as `group_task.blade.php`
```php 


@@extends('layouts.app')

@@section('content')
<?php use App\Http\Controllers\ConfigController; ?>
<div class="container-full">
		
			@@if(count($tasks)<>0)
			<div class="panel panel-default">
				<div class="panel-heading">
					Tasks
				</div>
				<div class="panel-body">
					

						<div id="no-more-tables" class="table-responsive">
						<table class="col-md-12  table table-hover">
							<thead class="cf">
								<th>#</th>
								<th >Task</th>
								<th>Description</th>
								<th>Priority</th>
								<th>Assignee</th>
								<th>Due Date</th>
								<th>Market For</th>
								<th>Status</th>
								<th>Dependency</th>
								<th style="width:20px;">Comments</th>
								<th>Next Steps</th>
							</thead>
							<tbody>
								<!--Loops in the tasks table and fetches all data in a row-->
								@@foreach ($tasks as $task)


									<!-- picks the priority and assigns class to it-->
									<tr	
										href="@{{ url('/details') }}/@{{ $task->id }}">

										<!--Priority ends-->

										<td data-title="#" class="table-text"><div><a href="@{{ url('/details') }}/@{{ $task->id }}" style="color:black;">@{{ $task->id }}</a></div></td>
										<td data-title="Task" class="table-text"><div>@{{ $task->task_name }}</div></td>
										<td data-title="Task Description"class="table-text"><div style="width:250px;overflow:auto;">@{!! nl2br($task->task_desc) !!}</div></td>
										<td data-title="Priority" class="table-text"><div>@{!! nl2br($task->priority) !!}</div></td>
										<td data-title="Assignees" class="table-text"><div>@{!! nl2br(ConfigController::get_workers($task->id)) !!}</div></td>
										<td data-title="Due Date"class="table-text"><div>@{!! nl2br($task->date_due) !!}</div></td>
										<td data-title="Market For"class="table-text"><div>
										<?php
											$markets = DB::table('markets')
												 ->where('task_id',$task->id)
												 ->get();

														$mcount= count($markets);
														$i = 1;

														foreach ($markets as $market) {
														echo $market->market;


															if ($i < $mcount) {
																echo", ";
																$i = $i+1;
															}
														}

										?>

										</div></td>
										<td data-title="Status"class="table-text"><div>@{!! nl2br($task->status) !!}</div></td>
										<td data-title="Dependency"class="table-text"><div>

												<?php
													//to fetch data from dependency db
													        $dependency= DB::table('dependency')
                											->where('task_id', '=', $task->id)
                											->orderBy('id', 'desc')
                											->take(1)
                											->get();
													?>	
													@@foreach($dependency as $dependencys)
														@@if($task->id == $dependencys->task_id)
														<!--<b style="font-size:10px">Updated on: @{{$dependencys->created_at}}</b><br />
														<p style="font-size:9px">@{!!nl2br($dependencys->dependency)!!} <br /><br /></p>
														-->
														@{!!nl2br($dependencys->dependency)!!}
													@@endif

													@@endforeach
													



										</div></td>
										
										<td data-title="Comments"class="table-text" style="width:20px;"><div style="width:300px;overflow:auto;">
											
													<?php
													//to fetch data from comments db
													        $comments= DB::table('comments')
                											->where('task_id', '=', $task->id)
                											->orderBy('id', 'desc')
                											->take(2)
                											->get();
													?>	
													@@foreach($comments as $comment)
														@@if($task->id == $comment->task_id)
														<b style="font-size:.7em; color:#cc0044;">Updated on: @{{$comment->created_at}}
																<?php
																$users = DB::table('users')
																		->where('id','=',$comment->user_id)
																		->get();
																	foreach ($users as $user ) {
																		echo "</br>Updated by ".$user->name;
																	}
															?>
														</b><br />
														<p style="font-size:.9em;">@{!!($comment->comment)!!}</p>
														
														@@endif
													
													@@endforeach
													
												
											</div>
										</td>

											<td data-title="Next Steps" class="table-text"><div style="width:300px;overflow:auto;">
											<?php
													//to fetch data from nextsteps db
											        $nextsteps= DB::table('nextsteps')
        											->where('task_id', '=', $task->id)
        											->orderBy('id', 'desc')
        											->take(2)
        											->get();
											?>	
											@@foreach($nextsteps as $nextstep)
												@@if($task->id == $nextstep->task_id)
														<b style="font-size:.7em; color:#cc0044;">Updated on: @{{$nextstep->created_at}}
															<?php
																
																$users = DB::table('users')
																		->where('id','=',$nextstep->user_id)
																		->get();
																	foreach ($users as $user ) {
																		echo "</br>Updated by ".$user->name;
																	}
															?>
														</b><br />
														<p style="font-size:.9em;">@{!!($nextstep->nextstep)!!}</p>
														
												@@endif
											@@endforeach


										</div></td>

									</tr>
								@@endforeach
								
								<?php 
									//echo $tasks->render();
								?>

							</tbody>
						</table>
					</div>
				</div>



			@@else
			
			@@endif
		</div>
	</div>
</div>


	@@endsection
```
<br><br>

<u>Search Views</u><br>
Edit `resources/views/tasks/searchTask.blade.php` with below content
```php

@@extends('layouts.app')

@@section('content')

<div class="container">
	<div  class="col-sm-offset-3 col-sm-6">
	<div class="panel panel-default">
			<div class="panel-heading">
				Search Tasks
			</div>
				<div class="panel-body">
				    <form action="@{{ url('/searchTask') }}" method="POST" class="form-horizontal" id="searchTask">
										@{{ csrf_field() }}

						<div class="form-group">
							<label for="type" class="col-sm-offset-1 col-sm-3 control-label">Search Type</label>

							<div class="col-sm-6">
								<select class="form-control" name="search_type">
									<option value="id">Task ID</option>
									<option value="name">Task Name</option>
									<option value="desc">Task Description</option>
								</select>
							</div>
						</div>

						<div class="form-group">
								<label for="type" class="col-sm-offset-1 col-sm-3 control-label">Search Term</label>

								<div class="col-sm-6">
									<input type="text" name="search_term" id="search_term" class="form-control" >
								</div>
						</div>

						<div class="form-group">
							<div class="col-sm-offset-5 col-sm-6">
								<button type="submit" class="btn btn-success">
									<i class="fa fa-btn fa-search"></i>Search
								</button>
							</div>
						</div>


				    </form>
				</div>
			</div>
	</div>
</div>

<div class="container-full" id="data">
	
</div>


<script type="text/javascript">
	$(document).ready(function(){
		$('#searchTask').submit(function(e){
			e.preventDefault();

			var data, url;

			data = $(this).serialize();
			url = $(this).attr('action');

			$.ajax({
				type:'post',
				url: url,
				data: data,
				success:function(data){
					if(data.html){
						$('#data').html(data.html);
					}
				},
				error:function(data){
					alert('Error, Please contact your administrator.');
				}
			});

		});
	});
</script>
@@endsection

```
<br><br>
Now add new file inside `resources/views/tasks/` as `data.blade.php` and add the below content in the file.
```php

<?php use App\Http\Controllers\ConfigController; ?>		
			@@if(count($tasks)<>0)
			<div class="panel panel-default">
				<div class="panel-heading">
					Tasks
				</div>
				<div class="panel-body">
					

						<div id="no-more-tables" class="table-responsive">
						<table class="col-md-12  table table-hover">
							<thead class="cf">
								<th>#</th>
								<th >Task</th>
								<th>Description</th>
								<th>Priority</th>
								<th>Assignee</th>
								<th>Due Date</th>
								<th>Market For</th>
								<th>Status</th>
								<th>Dependency</th>
								<th style="width:20px;">Comments</th>
								<th>Next Steps</th>
							</thead>
							<tbody>
								<!--Loops in the tasks table and fetches all data in a row-->
								@@foreach ($tasks as $task)


									<!-- picks the priority and assigns class to it-->
									<tr	
										href="@{{ url('/details') }}/@{{ $task->id }}">

										<!--Priority ends-->

										<td data-title="#" class="table-text"><div><a href="@{{ url('/details') }}/@{{ $task->id }}" style="color:black;">@{{ $task->id }}</a></div></td>
										<td data-title="Task" class="table-text"><div>@{{ $task->task_name }}</div></td>
										<td data-title="Task Description"class="table-text"><div style="width:250px;overflow:auto;">@{!! nl2br($task->task_desc) !!}</div></td>
										<td data-title="Priority" class="table-text"><div>@{!! nl2br($task->priority) !!}</div></td>
										<td data-title="Assignees" class="table-text"><div>@{!! nl2br(ConfigController::get_workers($task->id)) !!}</div></td>
										<td data-title="Due Date"class="table-text"><div>{@!! nl2br($task->date_due) !!}</div></td>
										<td data-title="Market For"class="table-text"><div>
										<?php
											$markets = DB::table('markets')
												 ->where('task_id',$task->id)
												 ->get();

														$mcount= count($markets);
														$i = 1;

														foreach ($markets as $market) {
														echo $market->market;


															if ($i < $mcount) {
																echo", ";
																$i = $i+1;
															}
														}

										?>

										</div></td>
										<td data-title="Status"class="table-text"><div>@{!! nl2br($task->status) !!}</div></td>
										<td data-title="Dependency"class="table-text"><div>

												<?php
													//to fetch data from dependency db
													        $dependency= DB::table('dependency')
                											->where('task_id', '=', $task->id)
                											->orderBy('id', 'desc')
                											->take(1)
                											->get();
													?>	
													@@foreach($dependency as $dependencys)
														@@if($task->id == $dependencys->task_id)
														<!--<b style="font-size:10px">Updated on: @{{$dependencys->created_at}}</b><br />
														<p style="font-size:9px">@{!!nl2br($dependencys->dependency)!!} <br /><br /></p>
														-->
														@{!!nl2br($dependencys->dependency)!!}
													@@endif

													@@endforeach
													



										</div></td>
										
										<td data-title="Comments"class="table-text" style="width:20px;"><div style="width:300px;overflow:auto;">
											
													<?php
													//to fetch data from comments db
													        $comments= DB::table('comments')
                											->where('task_id', '=', $task->id)
                											->orderBy('id', 'desc')
                											->take(2)
                											->get();
													?>	
													@@foreach($comments as $comment)
														@@if($task->id == $comment->task_id)
														<b style="font-size:.7em; color:#cc0044;">Updated on: @{{$comment->created_at}}
																<?php
																$users = DB::table('users')
																		->where('id','=',$comment->user_id)
																		->get();
																	foreach ($users as $user ) {
																		echo "</br>Updated by ".$user->name;
																	}
															?>
														</b><br />
														<p style="font-size:.9em;">@{!!($comment->comment)!!}</p>
														
														@@endif
													
													@@endforeach
													
												
											</div>
										</td>

											<td data-title="Next Steps" class="table-text"><div style="width:300px;overflow:auto;">
											<?php
													//to fetch data from nextsteps db
											        $nextsteps= DB::table('nextsteps')
        											->where('task_id', '=', $task->id)
        											->orderBy('id', 'desc')
        											->take(2)
        											->get();
											?>	
											@@foreach($nextsteps as $nextstep)
												@@if($task->id == $nextstep->task_id)
														<b style="font-size:.7em; color:#cc0044;">Updated on: @{{$nextstep->created_at}}
															<?php
																
																$users = DB::table('users')
																		->where('id','=',$nextstep->user_id)
																		->get();
																	foreach ($users as $user ) {
																		echo "</br>Updated by ".$user->name;
																	}
															?>
														</b><br />
														<p style="font-size:.9em;">@{!!($nextstep->nextstep)!!}</p>
														
												@@endif
											@@endforeach


										</div></td>

									</tr>
								@@endforeach
								
								<?php 
									//echo $tasks->render();
								?>

							</tbody>
						</table>
					</div>
				</div>
			</div>


			@@else
				<div class="alert alert-danger text-center">No Task Found !!! </div>
			@@endif
		

```
<br><br>




<a name="section-4"></a>
##Routes
Go to routes and edit below lines
```php 
Route::get('/task.group.view','TaskController@view_groups_task');
```
<a name="section-5"></a>
##Controllers
Go to TaskController, edit below lines:
```php 
    public function view_groups_task(){
        if(ConfigController::check_privilege('ACCESS_GROUP_VIEW'))
        {
          $tasks = DB::table('tasks AS t')
              ->join('users AS u', 't.user_id', '=', 'u.id')
              //the select statement makes work much easier when displaying this data on view
              ->select('t.*')
              ->where('u.group_id','=',Auth::user()->group_id)
              ->orderBy('t.created_at', 'desc')
              ->get();  


          return view('tasks.group_task')->with('tasks',$tasks);

        }
        else
        {
            return view('errors.no_access');
        }
    }

```

Also we need to edit search task functions in `TaskController`. Edit functions with below codes:
```php 
        public function searchTasks(){

          return view('tasks.searchTask');

        }

    public function searchTask(Request $request){
        if($request->ajax())
        {
            if(ConfigController::check_privilege('user_root'))
            {
                switch ($request->search_type) {
                case 'id':
                    $tasks = DB::table('tasks')
                                ->where('id',$request->search_term)
                                ->get();
                    break;
            
                case 'name':
                    $tasks = DB::table('tasks')
                                ->where('task_name','like','%'.$request->search_term.'%')
                                ->get();     
                    break;

                case 'desc':
                    $tasks = DB::table('tasks')
                                ->where('task_desc','like','%'.$request->search_term.'%')
                                ->get();     
                    break;
                }
                
                $view = view('tasks.data',compact('tasks'))->render();

            }
            elseif(ConfigController::check_privilege('ACCESS_GROUP_VIEW'))
            {
                $db = DB::table('tasks AS t')
                        ->join('users AS u', 't.user_id', '=', 'u.id')
                        //the select statement makes work much easier when displaying this data on view
                        ->select('t.*')
                        ->where('u.group_id','=',Auth::user()->group_id)
                        ->orderBy('t.created_at', 'desc');
                        
                switch ($request->search_type) {
                case 'id':
                    $tasks = $db->where('t.id',$request->search_term)
                                ->get();
                    break;
            
                case 'name':
                    $tasks = $db->where('t.task_name','like','%'.$request->search_term.'%')
                                ->get();     
                    break;

                case 'desc':
                    $tasks = $db->where('t.task_desc','like','%'.$request->search_term.'%')
                                ->get();     
                    break;
                }
                $view = view('tasks.data',compact('tasks'))->render();
            }
            else          
            {

                $view = '<div class="alert alert-danger" style="text-align:center;"><b>Sorry!!</b>You do not have access to this page.</div>';
            }

            return response()->json(['html'=>$view]);
        }
    }

```

Also changes made to close route. Changed method from `POST` to `GET`