#Version 7.0.0 Add Flexible Product
---
> {info} This feature is added to improve product flexibility

<br>
<br>

- [Migration](#section-1)
- [View](#section-2)
- [Controller](#section-3)
- [View](#section-4)


<a name="section-1"></a>
## Migration And Model

Run below statement to generate migration file
`php artisan make:migration add_product_type`
`php artisan make:migration add_amount_in_charges_table`

Add below statement inside up function in add_product_type file
```php 
    Schema::table('prices', function (Blueprint $table) 
    {
            $table->string('type')->nullable();
            $table->string('amount')->nullable()->change();
    });
```

Add below statement inside up function in add_amount_in_charges_table@ file
```php 
    Schema::table('charges', function (Blueprint $table) 
    {
            $table->string('amount')->nullable();
    });
```

Run `php artisan migrate` in cmd.


Edit Price model and add one more element `'type'` in $fillable array
```php
protected $fillable = ['name','status','description','amount','created_by','updated_by','labels','type'];
```

Edit Charge Model and add one more element `'amount'` in $fillable array
```php 
    protected $fillable = 
        ['ticket_id','price_id','patient_id','quantity','amount'];
```

<a name="section-2"></a>
#Part 1
## View
Make below changes in `prices/add.blade.php`


```php

    <div class="form-group" id="div-type">
        <label for="type" class="col-md-4 control-label">Type</label>

        <div class="col-md-6">
            <select name="type" id="type" class="form-control">
                <option value=""></option>
                <option value="f">Fixed</option>
                <option value="x">Flexible</option>
            </select>

            
                <span class="help-block">
                    <strong id="error_type"></strong>
                </span>
            
        </div>
    </div>

```

Also change the js and update it with below:
```js
<script type="text/javascript">
    $(document).ready(function(){
        $('#productAdd').submit(function(e){
            e.preventDefault();

            var url,formData;

            url = $(this).attr('action');
            formData = $('#productAdd').serialize();

            $.ajax({
                type:'post',
                data:formData,
                url:url,
                beforeSend:function(){
                    $('#submit').addClass('loading');

                    $('#div-name').removeClass('has-error');
                    $('#error_name').html('');

                    $('#div-price').removeClass('has-error');
                    $('#error_price').html('');

                    $('#alert').fadeOut('slow');
                    $('#alert_message').html('');

                    $('#div-labels').removeClass('has-error');
                    $('#error_labels').html('');                    

                    $('#div-type').removeClass('has-error');
                    $('#error_type').html('');
                },
                success:function(data){
                    @@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                        console.log(data);
                    @@endif

                    $('#submit').removeClass('loading');
                    
                    if(data.message){
                        $('#alert').fadeIn('slow');
                        $('#alert_message').html(data.message);
                    }
                },
                error:function(data){
                    @@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                        console.log(data.responseText);
                    @@endif

                    $('#submit').removeClass('loading');                    
                    
                    var obj = jQuery.parseJSON(data.responseText);
                    
                    if(obj.name){
                        $('#div-name').addClass('has-error');
                        $('#error_name').html(obj.name);
                    }

                    if(obj.price){
                        $('#div-price').addClass('has-error');
                        $('#error_price').html(obj.price);
                    }

                    if(obj.labels){
                        $('#div-labels').addClass('has-error');
                        $('#error_labels').html(obj.labels);
                    }

                    if(obj.type){
                        $('#div-type').addClass('has-error');
                        $('#error_type').html(obj.type);
                    }
                }
            });
        });

    });
</script>
```

Now, will change the `edit.blade.php` view

Edit the code with below:
```php

<div class="form-group" id="div-type">
    <label for="type" class="col-md-4 control-label">Type</label>

    <div class="col-md-6">
        <select name="type" id="type" class="form-control">
            <option value=""></option>
            <option @@if($product->type == 'f') selected="selected" @@endif value="f">Fixed</option>
            <option @@if($product->type == 'x') selected="selected" @@endif value="x">Flexible</option>
        </select>
            <span class="help-block">
                <strong id="error_type"></strong>
            </span>
        
    </div>
</div>

```

On the same `edit.blade.php` file replace the js script with below code

```js
<script type="text/javascript">
    $(document).ready(function(){
        $('#productEdit').submit(function(e){
            e.preventDefault();

            var url,formData;

            url = $(this).attr('action');
            formData = $('#productEdit').serialize();

            $.ajax({
                type:'post',
                data:formData,
                url:url,
                beforeSend:function(){
                    $('#submit').addClass('loading');

                    $('#div-name').removeClass('has-error');
                    $('#error_name').html('');

                    $('#div-price').removeClass('has-error');
                    $('#error_price').html('');

                    $('#alert').fadeOut('slow');
                    $('#alert_message').html('');

                    $('#div-labels').removeClass('has-error');
                    $('#error_labels').html('');

                    $('#div-type').removeClass('has-error');
                    $('#error_type').html('');
                },
                success:function(data){
                    @@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                        console.log(data);
                    @@endif                  

                    $('#submit').removeClass('loading');
                    
                    if(data.message){
                        $('#alert').fadeIn('slow');
                        $('#alert_message').html(data.message);
                    }
                },
                error:function(data){
                    @@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                        console.log(data.responseText);
                    @@endif

                    $('#submit').removeClass('loading');                    
                    
                    var obj = jQuery.parseJSON(data.responseText);
                    
                    if(obj.name){
                        $('#div-name').addClass('has-error');
                        $('#error_name').html(obj.name);
                    }

                    if(obj.price){
                        $('#div-price').addClass('has-error');
                        $('#error_price').html(obj.price);
                    }

                    if(obj.labels){
                        $('#div-labels').addClass('has-error');
                        $('#error_labels').html(obj.labels);
                    }
                    if(obj.type){
                        $('#div-type').addClass('has-error');
                        $('#error_type').html(obj.type);
                    }
                }
            });
        });

    });
</script>
```


<a name="section-3"></a>
## Controllers
Change save_price function with below scripts in `PriceController.php`
```php
        if(ConfigController::check_privilege('ACCESS_ADD_PRICE'))
        {
            $this->validate($request,[
                'type' => 'required',
            ]);

            if($request->type == 'f')
            {
                $this->validate($request,[
                    'name' => 'required',
                    'price' => 'required',
                    'labels' => 'required'
                ]);


                Price::create([
                    'name' => $request->name,
                    'description' => $request->description,
                    'status' => 'a',
                    'labels' => $request->labels,
                    'type' => $request->type,
                    'amount' => $request->price,
                    'created_by' => Auth::user()->id,
                    'updated_by' => Auth::user()->id

                ]);
            }


            if($request->type == 'x')
            {
                $this->validate($request,[
                    'name' => 'required',
                    'labels' => 'required'
                ]);


                Price::create([
                    'name' => $request->name,
                    'description' => $request->description,
                    'status' => 'a',
                    'labels' => $request->labels,
                    'type' => $request->type,
                    'created_by' => Auth::user()->id,
                    'updated_by' => Auth::user()->id

                ]);
            }


            return response()->json(['message' => 'Product Name: '.$request->name.' has been added.']);
        }
        else
        {
            return view('errors.not_authorized');
        }   
```

Now replace the update_products function on `PriceController.php`

```php
if(ConfigController::check_privilege('ACCESS_EDIT_PRICE'))
{

    $this->validate($request,[
        'type' => 'required'
    ]);

    if($request->type == 'f')
    {
        $this->validate($request,[
            'name' => 'required',
            'price' => 'required',
            'labels'=> 'required'
        ]);


        $product = Price::find($request->id);
        $product->name = $request->name;
        $product->description = $request->description;
        $product->labels = $request->labels;
        $product->type = $request->type;
        $product->amount = $request->price;
        $product->updated_by = Auth::user()->id;
        $product->save();
    }

    if($request->type == 'x')
    {
        $this->validate($request,[
            'name' => 'required',
            'labels'=> 'required'
        ]);


        $product = Price::find($request->id);
        $product->name = $request->name;
        $product->description = $request->description;
        $product->labels = $request->labels;
        $product->type = $request->type;
        $product->updated_by = Auth::user()->id;
        $product->save();
    }

    return response()->json(['message' => 'Product has been updated']);
}
else
{
    return view('errors.not_authorized');
}

return response()->json(['message' => 'Product has been updated.']);
```

#Part 2
<a name="section-4"></a>
##View
Change in view `tickets.product_data`, replace with below code
```php
@@if(count($products) > 0)

    <div class="row" style="font-size: 10px;">
    @@foreach($products as $product)
        <div class="col-md-3 col-sm-2 col-lg-2 col-xs-6">
            <button onclick="add_cost(@{{$product->id.',"'.$product->type.'"'}});" type="button" class="btn btn-xs btn-primary" style="text-align: center; width: 100px; word-wrap: break-word; height:100px; margin-top: 10px;">@{{$product->name}} <br> @{{$product->amount}}</button>
        </div>
    @@endforeach
    </div>  

@@else
    <div class="alert alert-danger">No products defined.</div>
@@endif
```

Also replace the add_cost function js in `tickets.read` file:
```js
function add_cost(id,product_type)
{
    if(product_type==='x')
    {
        checks(id,product_type);
    }

    if(product_type === 'f')
    {

    
        $.ajax({
            url: "@{{url('ticket.products.add')}}",
            type:"POST",
            data:{
                '_token': $('input[name=_token]').val(),
                'ticket_id': '@{{$ticket_id}}',
                'patient_id': '@{{$patient_id}}',
                'product_id': id,
                'type': product_type,
            },
            success:function(data){
                console.log(data);
                if(data.html){
                    swal({
                            type: 'success',
                            title: 'Yah, Product added !!!',
                            animation: true
                    });
                

                    $('#cost-data').html(data.html);
                }

                if(data.unauthorized_access){
                    swal({
                            type: 'error',
                            title: 'Oops...',
                            text: data.unauthorized_access,
                            animation: true
                    });
                }


            },
            error:function(data){
                swal({
                        type: 'error',
                        title: 'Error!!!',
                        text: 'Something went wrong. Please try again later.',
                        animation: true
                });
            }
        });
    }

}//end add_cost function
```

A new js function named checks is added on the `tickets.read` file. Please add below:
```js
function checks(id,product_type)
{
    var result = null;
    $.ajax({
            url: "@{{url('charges.products.checks')}}",
            type:"POST",
            data:{
                '_token': $('input[name=_token]').val(),
                'ticket_id': '@{{$id}}',
                'product_id': id
            },
            success:function(data){
                if(data.result === '0')
                {
                    $.ajax({
                        url: "@{{url('ticket.products.add')}}",
                        type:"POST",
                        data:{
                            '_token': $('input[name=_token]').val(),
                            'ticket_id': '@{{$id}}',
                            'patient_id': '@{{$patient_id}}',
                            'product_id': id,
                            'type': product_type,
                        },
                        success:function(result){
                            stop_loader();
                            console.log(result);
                            if(result.html){
                                swal({
                                        type: 'success',
                                        title: 'Yah, Product added !!!',
                                        animation: true
                                });
                            

                                $('#cost-data').html(result.html);
                            }

                            if(result.unauthorized_access){
                                swal({
                                        type: 'error',
                                        title: 'Oops...',
                                        text: data.unauthorized_access,
                                        animation: true
                                });
                            }


                        },
                        error:function(result){
                            
                            swal({
                                    type: 'error',
                                    title: 'Error!!!',
                                    text: 'Something went wrong. Please try again later.',
                                    animation: true
                            });
                        }
                    });
                }
                
                if(data.result === '1') //return false 
                {
                    
                    document.getElementById('modal_product_id').value = id;
                    document.getElementById('modal_type').value = product_type;
                    document.getElementById('modal_amount').value = '';
                    $('#modal-add').modal('show');
                }
            },
            error:function(data){
                stop_loader();
                swal({
                        type: 'error',
                        title: 'Error!!!',
                        text: 'Something went wrong. Please try again later.',
                        animation: true
                });
            }
        });

    return result;
}
```

Add below modal:
```php 
<!-- MODAL -->
<div class="modal fade" id="modal-add">
    <div class="modal-dialog">
      <div class="modal-content">
      
        <!-- Modal Header -->
        <div class="modal-header">
          <h4 class="modal-title">Add Items</h4>
        </div>

        <!-- Modal body -->
        <div class="modal-body">
                <form id="addChargeItems" method="POST" action="@{{url('ticket.products.add')}}">
                    @{{ csrf_field() }}
                    <div class="form-group">
                        <div>
                            <input type="hidden" name="ticket_id" id="modal_ticket_id" value="@{{$id}}">
                            <input type="hidden" name="patient_id" id="modal_patient_id" value="@{{$patient_id}}">
                            <input type="hidden" name="product_id" id="modal_product_id">
                            <input type="hidden" name="type" id="modal_type">
                            <input type="text" class="form-control" name="amount" id="modal_amount" placeholder="Enter Amount ... ">
                        </div>
                    </div>                   
                </form>
        </div>
        
        <!-- Modal footer -->
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary" id="submit-add">Add</button>

          <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
        </div>
        
      </div>
    </div>
  </div>
<!-- MODAL END -->
```

We also have add js for add products in `tickets.read` file;
```php
        $('#submit-add').on('click',function(e){
            e.preventDefault();
            var form, url;
            url = $('#addChargeItems').attr('action');
            form = $('#addChargeItems').serialize();
            
                    $.ajax({
                    url: url,
                    type:"POST",
                    data:form,
                    success:function(data){
                        
                        console.log(data);
                        if(data.html){
                            
                                swal({
                                        type: 'success',
                                        title: 'Yah, Product added !!!',
                                        animation: true
                                });
                            

                            $('#cost-data').html(data.html);
                        }

                        if(data.unauthorized_access){
                            swal({
                                    type: 'error',
                                    title: 'Oops...',
                                    text: data.unauthorized_access,
                                    animation: true
                            });
                        }


                    },
                    error:function(data){
                        
                        swal({
                                type: 'error',
                                title: 'Error!!!',
                                text: 'Something went wrong. Please try again later.',
                                animation: true
                        });
                    }
                });
        });
```
##Controller
Function named read_ticket has been updated. On `products` variable, `type` element has been added.
```php 
    public function read_ticket($id,$patient_id){
        //ACCESS_READ_TICKETS
        $ticket_id = $id;//v5.0.0
        if(ConfigController::check_privilege('ACCESS_READ_TICKETS')){
            $check = Ticket::where('id',$id)
                           ->whereIn('status',['u','c'])
                           ->get();


            if(count($check) > '0'){
                return view('tickets.error_closed');
            }
            else
            {

                //v5.0.0  
                $charges = Charge::where('ticket_id',$id)
                                 ->get();
                //end  v5.0.0  

                //For Admin reads the ticket it wont update the ticket to pending 
                if(Auth::user()->role_id <> '1')
                {
                //Update the ticket status to pending
                Ticket::where('id',$id)
                      ->where('status','<>','c')
                      ->update(['updated_by' => Auth::user()->id,
                                'status'  => 'p'
                ]);

                $tickets = DB::table('ticket_with_doctor')
                             ->where('doctor_id', Auth::user()->id)
                             ->where('id', $id)
                             ->get();


                }
                else//if Admin
                {
                $tickets = DB::table('ticket_with_doctor')
                             ->where('id', $id)
                             ->get();
                }  



                

                $pmhs = DB::table('view_closed_tickets')
                          ->where('patient_id',$patient_id)
                          ->where('transaction_type','Sale')
                          ->where('invoice_type','Normal')
                          ->orderBy('id','desc')
                          ->take(10)
                          ->get();

                $diagnostics = Diagnostic::where('patient_id',$patient_id)->get();


                $products = Price::select('id','name','description','amount','type')->get();


                return view('tickets.read',compact('id','tickets','pmhs','patient_id','products','charges','diagnostics','ticket_id'));
             
            }
        }
        else
        {
            return view('errors.not_authorized');
        }

    }
```

Changes made to addProductsToCharges function. Added Flexible feature
```php
    public function addProductsToCharges(Request $request)
    {
            if(ConfigController::check_privilege('ACCESS_READ_TICKETS'))
            {

                //Check if there is any existing products in Charge table with the same ticket number
                if($request->type == 'f')
                {
                    $checks = Charge::where('ticket_id',$request->ticket_id)
                                   ->where('price_id',$request->product_id)
                                   ->where('patient_id',$request->patient_id)
                                   ->get();


                    if(count($checks)== 1)
                    {
                        foreach($checks as $check)
                        {
                            $post_charge = Charge::find($check->id);
                            $post_charge->quantity = $post_charge->quantity + 1;
                            $post_charge->save();
                        }
                    }
                    else
                    {
                        
                        $post_charge = new Charge;
                        $post_charge->ticket_id = $request->ticket_id;
                        $post_charge->price_id = $request->product_id;
                        $post_charge->patient_id = $request->patient_id;
                        $post_charge->amount = ConfigController::get_product_price($request->product_id);
                        $post_charge->quantity = 1;
                        $post_charge->save();
                    } 
                }


                if($request->type == 'x')
                {
                    $checks = Charge::where('ticket_id',$request->ticket_id)
                                   ->where('price_id',$request->product_id)
                                   ->where('patient_id',$request->patient_id)
                                   ->get();


                    if(count($checks)== 1)
                    {
                        foreach($checks as $check)
                        {
                            $post_charge = Charge::find($check->id);
                            $post_charge->quantity = $post_charge->quantity + 1;
                            $post_charge->save();
                        }
                    }
                    else
                    {
                        
                        $post_charge = new Charge;
                        $post_charge->ticket_id = $request->ticket_id;
                        $post_charge->price_id = $request->product_id;
                        $post_charge->patient_id = $request->patient_id;
                        $post_charge->amount = $request->amount;
                        $post_charge->quantity = 1;
                        $post_charge->save();
                    } 
                }
                //collect all data in charges table
                $charges = Charge::where('ticket_id',$request->ticket_id)
                                 ->get();



                if ($request->ajax()) {
                    $view = view('tickets.read_data',compact('charges'))->render();

                    return response()->json(['html'=>$view]);

                }//Ajax end here

            }
            else
            {
                return response()->json(['unauthorized_access'=>'Sorry, you do not have access to this service. Please contact Admin.']);
            }
    }
```

On TicketController, we will also add another function that will check the charges table to see if there is any existing product in there for that ticket id. Function name is `check_products`
```php
    public function check_products(Request $request)
    {
        $tickets = Charge::where('price_id',$request->product_id)
                         ->where('ticket_id',$request->ticket_id)
                         ->get();

        if(count($tickets) == 1)
        {
            return response()->json(['result' => '0']);
        }
        else
        {
            return response()->json(['result' => '1']);
        }        
    }
```


##Routes
Add below routes in the `route.web`
```php
Route::post('charges.products.checks','TicketController@check_products');
```




There are changes in function name 
-   get_cost_breakdown 
-   get_cost_breakdown_email 
-   items_breakdown_json
-   barcode_breakdown
```php
    public static function get_cost_breakdown($ticket_id)
    {
        $charges = Charge::where('ticket_id',$ticket_id)->get();

        $cost_breakdown = '';

        if(count($charges)>'0')
        {
            foreach ($charges as $charge) {
                # code...
            
                $cost_breakdown .= '<li style="font-size: 10px; display: block;" class="breakdown@{{$charge->id}}">'.ConfigController::get_product_name($charge->price_id).' (<b>'.$charge->quantity.'</b>) - <b>$'.$charge->amount.' </b></li>';

            }

        }
        else
        {
            $cost_breakdown .= '<li style="font-size: 10px; display: block;">None</b></li>';
        }

        return $cost_breakdown;
    }


        public static function get_cost_breakdown_email($ticket_id){
        $charges = Charge::where('ticket_id',$ticket_id)->get();

        $breakdown = '';

        if(count($charges)>'0')
        {
            foreach ($charges as $charge) {
                # code...
            
                $breakdown .= '<tr><td>'.ConfigController::get_product_name($charge->price_id).' (<b>'.$charge->quantity.'</b> </td><td> $'.$charge->amount.'</td><td> FJD </td></tr>';

            }

        }
        else
        {
            $breakdown .= '<tr colspan = "2"><td>None</td></tr>';
        }

        return $breakdown;      
    }


    public static function items_breakdown_json($id,$amount,$patient_id)
    {
        $charges = Charge::where('ticket_id',$id)->get();
        
        $value = '';
        $count = 1;

        $charges_count = count($charges);

        // if(ConfigController::get_patient_insurance($patient_id) == 'None')//If customer has no Insurance
        // {
            if(count($charges)>0)
            {
                foreach ($charges as $charge) 
                {
                    $value .= '{
                                    "GTIN": null,
                                    "Name": "'.ConfigController::get_product_name($charge->price_id).'",
                                    "Quantity": '.$charge->quantity.',
                                    "UnitPrice":'.$charge->amount.',
                                    "Labels": [
                                        "'.ConfigController::get_product_labels($charge->price_id).'"
                                    ],
                                    "TotalAmount": '.$charge->amount * $charge->quantity.'
                                }';
                    if($count <> $charges_count)
                    {
                        $value .= ',';
                    }

                    $count++;
                }
            }

        echo $value;

    }



    public static function barcode_breakdown($ticket_id){
        $charges = Charge::where('ticket_id',$ticket_id)->get();

        $breakdown = '';

        if(count($charges)>'0')
        {
            foreach ($charges as $charge) {
                # code...
            
                $breakdown .= '<span><span class="text-left">'.ConfigController::get_product_name($charge->price_id).'</span><span class="text-right"> $'.$charge->amount.' FJD</span></span><br>';
            }

        }
        else
        {
            $breakdown .= '<tr colspan = "2"><td>None</td></tr>';
        }

        echo $breakdown;        
    }

```



#SQL
Need to update the DB with below SQL query
```SQL
update prices set type='f';
```


Another SQL needed here to put all the amounts in charges table. 
Due to this, it will impact other places as well.
```SQL
update charges c, prices p set c.amount = p.amount where c.price_id = p.id;  
```

The major problem with old version of the list tickets were that we used get type to refresh data. 
This has been changed to 'POST'
JS script has been changed on `tickets.open` file
```js
<script type="text/javascript">
    $(document).ready(function(){
        setInterval(function(){ 
            refresh(); 
        }, 30000);

    });

    function refresh(){
        
        $.ajax(
            {
                url: "@{{url('/ticket.open')}}",
                type: "post",
                data:{'_token': $('input[name=_token]').val()},
                beforeSend: function()
                {
                    $('.ajax-load').fadeIn('slow');
                },
                error:function(data){
                  @@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                    console.log(data.responseText);
                  @@endif                        
                }
            })
            .done(function(data)
            {
                @@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                  console.log(data);
                @@endif 

                if(data.html == ""){
                    //$('.ajax-load').html("No more records found");
                    return;
                }
                $('.ajax-load').fadeOut('slow');
                $("#post-data").html(data.html);
            })
            .fail(function(jqXHR, ajaxOptions, thrownError, data)
            {
                $('.ajax-load').hide();
                  //alert('server not responding...');
            });
    }
</script>
```

`tickets.hold` script change below:
```js
<script type="text/javascript">
    $(document).ready(function(){
        setInterval(function(){ 
            refresh(); 
        }, 30000);

    });

    function refresh(){
        
        $.ajax(
            {
                url: "@{{url('/ticket.hold')}}",
                type: "post",
                data:{'_token': $('input[name=_token]').val()},
                beforeSend: function()
                {
                    $('.ajax-load').fadeIn('slow');
                },
                error:function(data){
                  @@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                    console.log(data.responseText);
                  @@endif                        
                }
            })
            .done(function(data)
            {
                @@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                  console.log(data);
                @@endif 

                if(data.html == ""){
                    //$('.ajax-load').html("No more records found");
                    return;
                }
                $('.ajax-load').fadeOut('slow');
                $("#post-data").html(data.html);
            })
            .fail(function(jqXHR, ajaxOptions, thrownError, data)
            {
                $('.ajax-load').hide();
                  //alert('server not responding...');
            });
    }
</script>
```

`tickets.pending` change below

```js
<script type="text/javascript">
    $(document).ready(function(){
        setInterval(function(){ 
            refresh(); 
        }, 30000);

    });

    function refresh(){
        
        $.ajax(
            {
                url: "@{{url('/ticket.pending')}}",
                type: "post",
                data:{'_token': $('input[name=_token]').val()},
                beforeSend: function()
                {
                    $('.ajax-load').fadeIn('slow');
                },
                error:function(data){
                @@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                  console.log(data.responseText);
                @@endif      
                }
            })
            .done(function(data)
            {
                @@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                  console.log(data);
                @@endif     

                if(data.html == ""){
                    //$('.ajax-load').html("No more records found");
                    return;
                }
                $('.ajax-load').fadeOut('slow');
                $("#post-data").html(data.html);
            })
            .fail(function(jqXHR, ajaxOptions, thrownError, data)
            {
                $('.ajax-load').hide();
                  //alert('server not responding...');
            });
    }
</script>
```



`tickets.pending` change below

```js
<script type="text/javascript">
    function refresh(){
        
        $.ajax(
                {
                    url: "@{{url('/ticket.unpaid.list')}}",
                    type: "post",
                    data:{'_token': $('input[name=_token]').val()},
                    beforeSend: function()
                    {
                        $('.ajax-load').fadeIn('slow');
                    },
                    error:function(data){
                      @@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                        console.log(data.responseText);
                      @@endif      
                    }
                })
                .done(function(data)
                {
                    @@if(ConfigController::check_privilege('ACCESS_JAVASCRIPT_LOGS'))
                      console.log(data);
                    @@endif     

                    if(data.html == ""){
                        //$('.ajax-load').html("No more records found");
                        return;
                    }
                    $('.ajax-load').fadeOut('slow');
                    $("#post-data").html(data.html);
                })
                .fail(function(jqXHR, ajaxOptions, thrownError, data)
                {
                  $('.ajax-load').hide();
                      //alert('server not responding...');
                });
    }
</script>
```

Route change is as per below:
```php
Route::post('ticket.open', 'TicketController@view_open_tickets');
Route::post('/ticket.hold','TicketController@view_hold_tickets');
Route::post('/ticket.unpaid.list','TicketController@list_unpaid_tickets');
Route::post('/ticket.pending','TicketController@view_pending_tickets');
Route::get('/frcs.file.load.error','TicketController@view_frcs_file_error');

```


Also have to change label function in Config Controller:
```php
    public static function get_product_labels($id)
    {
        $product = Price::find($id);

        if($product->name<> null)
        {
            return $product->labels;
        }
        else
        {
            return '';
        }
    }
```

Also changes made to FRCS pay_n_close file.

Below is the new content for `tickets.pay_n_close`
```js

  window.addEventListener('load', function() {
    let script = document.createElement('script');
    script.src = "@{{config('app.firca_js')}}"; 
    document.head.append(script);

    script.onload  = function(data) {
        @@if(Auth::user()->pac_status == 'y')
          $('#pac_auth').modal({
                backdrop: 'static',
                keyboard: false
          });
        @@endif
    };

    script.onerror = function(data) {
        window.location.href = '@{{url("frcs.file.load.error")}}';
    };
  });

```

Also change in `TicketController` and create a new file `errors.frcs_file_load`

TicketController content below:
```php
    public function view_frcs_file_error()
    {
        return view('errors.frcs_file_load');
    }

```

`errors.frcs_file_load` content below:

```php
@@extends('layouts.app')



TicketController code as per below:
```php
    public function get_frcs_info($id)
    {
        if(ConfigController::check_privilege('ACCESS_FRCS_INFO'))
        {
            $ticket =  Ticket::find($id);

            if($ticket->id <> '')
            {
                return view('tickets.info',compact('ticket'));
            }
            else
            {
                return view('errors.ticket_not_exist');
            }
        }
        else
        {
            return view('errors.not_authorized');
        }
    }
```


##View
View file name is `info.blade.php`. Below are the content:
```php
@@extends('layouts.app')

@@section('content')

<link rel="stylesheet" href="@{{url('css/mystyle.css')}}">
        <div class="col-sm-12 col-md-8 col-md-offset-2">
            <figure class="infobox infobox-more  bg-red">
                <span class="icon-wrap"><i class="fa fa-money"></i></span>
                <figcaption class="text-wrap">

                    <h5 class="title">Ticket Info - @{{$ticket->id}}</h5>
                    <hr>
                    <div class="form-group">
                        <label class="label-control col-md-offset-3 col-md-3">FRCS Status : </label>
                        <label class="label-control col-md-6">@{{ConfigController::get_status($ticket->status)}}
                    </div>
                    <div class="form-group">
                        <label class="label-control col-md-offset-3 col-md-3">FRCS Ref No : </label>
                        <label class="label-control col-md-6">@{{$ticket->tax_invoice_number}}</label>
                    </div>

                    <div class="form-group">
                        <label class="label-control col-md-offset-3 col-md-3">Invoice Type : </label>
                        <label class="label-control col-md-6">@{{$ticket->invoice_type}}</label>
                    </div>

                    <div class="form-group">
                        <label class="label-control col-md-offset-3 col-md-3">Transaction Type : </label>
                        <label class="label-control col-md-6">@{{$ticket->transaction_type}}</label>
                    </div>

                </figcaption>
            </figure> <!-- infobox // -->
        </div><!-- col // -->
@@endsection
```

@@section('content')
<div class="container">
    <div class="alert alert-danger">
        <span><strong>Sorry, FRCS certificate not loaded. Please restart your browser and try again.</strong></span>
    </div>  
</div>
@@endsection
```

#FRCS REF NO.
The medical portal doesnt have frcs ref number visible on the portal.
To make it visible below steps are needed.

##Route

```php
Route::get('frcs.ticket.info.{id}','TicketController@get_frcs_info');
```

##Controller
For controllers, we are changing two controllers one is TicketController and Another is ConfigController
Below are the codes for ConfigController
```php
    public static function get_status($status)
    {
        switch ($status) {
            case 'c':
                return 'Closed';
                break;
                
            case 'p':
                return 'Pending';
                break;
                            
            case 'a':
                return 'Open';
                break;
                        
            case 'h':
                return 'Hold';
                break;
                        
            case 'u':
                return 'Unpaid';
                break;
                        
            case 'x':
                return 'Processing';
                break;
                        
            case 'c':
                return 'Closed';
                break;
        }
    }
```


TicketController code as per below:
```php
    public function get_frcs_info($id)
    {
        if(ConfigController::check_privilege('ACCESS_FRCS_INFO'))
        {
            $ticket =  Ticket::find($id);

            if($ticket->id <> '')
            {
                return view('tickets.info',compact('ticket'));
            }
            else
            {
                return view('errors.ticket_not_exist');
            }
        }
        else
        {
            return view('errors.not_authorized');
        }
    }
```



##View
View file name is `info.blade.php`. Below are the content:
```php
@@extends('layouts.app')

@@section('content')
<?php use App\Http\Controllers\ConfigController; ?>
<link rel="stylesheet" href="@{{url('css/mystyle.css')}}">
        <div class="col-sm-12 col-md-8 col-md-offset-2">
            <figure class="infobox infobox-more  bg-red">
                <span class="icon-wrap"><i class="fa fa-money"></i></span>
                <figcaption class="text-wrap">

                    <h5 class="title">Ticket Info - @{{$ticket->id}}</h5>
                    <hr>
                    <div class="form-group">
                        <label class="label-control col-md-offset-3 col-md-3">FRCS Status : </label>
                        <label class="label-control col-md-6">@{{ConfigController::get_status($ticket->status)}}
                    </div>
                    <div class="form-group">
                        <label class="label-control col-md-offset-3 col-md-3">FRCS Ref No : </label>
                        <label class="label-control col-md-6">@{{$ticket->tax_invoice_number}}</label>
                    </div>

                    <div class="form-group">
                        <label class="label-control col-md-offset-3 col-md-3">Invoice Type : </label>
                        <label class="label-control col-md-6">@{{$ticket->invoice_type}}</label>
                    </div>

                    <div class="form-group">
                        <label class="label-control col-md-offset-3 col-md-3">Transaction Type : </label>
                        <label class="label-control col-md-6">@{{$ticket->transaction_type}}</label>
                    </div>

                </figcaption>
            </figure> <!-- infobox // -->
        </div><!-- col // -->
@@endsection
```

#Export Last 3 months Data 
For exporting data below are the changes that will need:
- `route.web`
```php
Route::get('export.last.quarter','TicketController@export_data');
```
TicketController
```php
    public function export_data()
    {
        //get current month
        $start_date  =  date('Y-m');

        $end_date = date("Y-m", strtotime("-3 months"));

        $data = Ticket::select('id','updated_at','status','total_amount','tax_amount','invoice_type','transaction_type','tax_invoice_number','rollback_id')
                        ->where('updated_at','<=',$start_date.'-01 00:00:00')
                        ->where('updated_at','>=',$end_date.'-01 00:00:00')
                        ->where('invoice_type','Normal')
                        ->where('transaction_type','Sale')
                        ->get();

        Excel::create('Last 3 Months Data', function($excel) use ($data) {
            $excel->sheet('Excel', function($sheet) use ($data) {
            $sheet->loadView('reports.report')->with("data", $data);
                //freezepane first row
                $sheet->freezeFirstRow();
            });



        })->download('csv');
             
    }
```
Copy the reports folder from resource to the ftp server