#Version 5.3.4 FRCS XML Upload
---
> {info} This feature is added to improve adding products to charges table. This feature will avoid any duplications.

<br>
<br>

- [Route](#section-1)
- [CSS](#section-2)
- [Controller](#section-3)
- [View](#section-4)


<a name="section-1"></a>
## Route
Now add below routes in `routes/web.php`
```php
//FRCS XML Routes 
Route::post('ticket.products.search','TicketController@seachProducts');
Route::post('ticket.products.add','TicketController@addProductsToCharges');
Route::post('ticket.product.one.remove','TicketController@removeOneProductsToCharges');
Route::post('ticket.product.remove','TicketController@removeProductsToCharges');

```

<a name="section-2"></a>
## CSS
Make below changes in `css/style.css`
```css

#product_well{
    width: 670px;
    height: 267px;
    overflow: scroll;
}

```

<a name="section-3"></a>
## Controller
Add below scripts in `TicketController.php`
```php
    public function addProductsToCharges(Request $request)
    {
            if(ConfigController::check_privilege('ACCESS_READ_TICKETS'))
            {

                //Check if there is any existing products in Charge table with the same ticket number

                $checks = Charge::where('ticket_id',$request->ticket_id)
                               ->where('price_id',$request->product_id)
                               ->where('patient_id',$request->patient_id)
                               ->get();


                if(count($checks)== 1)
                {
                    foreach($checks as $check)
                    {
                        $post_charge = Charge::find($check->id);
                        $post_charge->quantity = $post_charge->quantity + 1;
                        $post_charge->save();
                    }
                }
                else
                {
                    
                    $post_charge = new Charge;
                    $post_charge->ticket_id = $request->ticket_id;
                    $post_charge->price_id = $request->product_id;
                    $post_charge->patient_id = $request->patient_id;
                    $post_charge->quantity = 1;
                    $post_charge->save();
                } 

                //collect all data in charges table
                $charges = Charge::where('ticket_id',$request->ticket_id)
                                 ->get();



                if ($request->ajax()) {
                    $view = view('tickets.read_data',compact('charges'))->render();

                    return response()->json(['html'=>$view]);

                }//Ajax end here

            }
            else
            {
                return response()->json(['unauthorized_access'=>'Sorry, you do not have access to this service. Please contact Admin.']);
            }
    }


    public function removeOneProductsToCharges(Request $request)
    {
            if(ConfigController::check_privilege('ACCESS_READ_TICKETS'))
            {

                    $data = Charge::find($request->charge_id);

                    if($data->quantity == 1)
                    {
                        $data->delete();
                    }
                    else
                    {
                        $data->quantity = $data->quantity -1;
                        $data->save();
                    }

                $charges = Charge::where('ticket_id',$request->ticket_id)->get();
                if ($request->ajax()) {
                    $view = view('tickets.read_data',compact('charges'))->render();

                    return response()->json(['html'=>$view]);

                }//Ajax end here
            }
            else
            {
                return response()->json(['unauthorized_access'=>'Sorry, you do not have access to this service. Please contact Admin.']);
            }
    }


    public function removeProductsToCharges(Request $request)
    {
            if(ConfigController::check_privilege('ACCESS_READ_TICKETS'))
            {

                    $data = Charge::find($request->charge_id);      
                    $data->delete();

                $charges = Charge::where('ticket_id',$request->ticket_id)->get();

                if ($request->ajax()) {
                    $view = view('tickets.read_data',compact('charges'))->render();

                    return response()->json(['html'=>$view]);

                }//Ajax end here
            }
            else
            {
                return response()->json(['unauthorized_access'=>'Sorry, you do not have access to this service. Please contact Admin.']);
            }
    }


    public function seachProducts(Request $request)
    {

                if ($request->ajax()) {
                    $products = Price::where('name','like','%'.$request->name.'%')->get();
                    $view = view('tickets.product_data',compact('products'))->render();

                    return response()->json(['products'=>$view]);

                }//Ajax end here
    }
```

Also edit `update_ticket` function in `TicketController.php`
```php 
    public function update_ticket(Request $request){
        //return response()->json(['status' => $request->action]);
        if(ConfigController::check_privilege('ACCESS_UPDATE_TICKETS')){

            //extract products before 
            $products = Price::all();

            switch ($request->action) {
                //if doctor clicks on close button then it will close the ticket
                case 'close':
                        // v5.0.0
                        $product_counter = Charge::where('ticket_id',$request->ticket_id)
                                               ->get();
                        // end  v5.0.0  
                        if(count($product_counter) == 0)
                        {
                            return response()->json(['error_product' => 'Opps, Ticket not processed. Please select a product']);
                        }

                        if($request->diagnostic_value == 'yes'){
                            $this->validate($request,[
                                'sickness' => 'required',
                                'prescription' => 'required',
                                'diagnostic_type' => 'required',
                                'results' => 'required'
                            ]);

 

                            //Updating Ticket table
                            Ticket::where('id',$request->ticket_id)
                                  ->where('status','p')
                                  ->update(['sickness' => $request->sickness,
                                            'BP' => $request->BP,
                                            'P' => $request->P,
                                            'CBG' => $request->CBG,
                                            'TEMP' => $request->TEMP,
                                            'updated_by' => Auth::user()->id,
                                            'closed_by' => Auth::user()->id,
                                            'prescription' => $request->prescription,
                                            'insurance_id' => $request->insurance_id,
                                            'status' => 'u',
                                            'discount' => $request->discount_amount,
                                            'total_amount' => $request->total_cost
                            ]); 

                            Diagnostic::create([
                                'ticket_id' => $request->ticket_id,
                                'diagnostic_type' => $request->diagnostic_type,
                                'result' => $request->results,
                                'patient_id' => $request->patient_id
                            ]);

                        }
                    else
                        {
                            $this->validate($request,[
                                'sickness' => 'required',
                                'prescription' => 'required'
                            ]);  


                            

                            //Updating the DB
                            Ticket::where('id',$request->ticket_id)
                                  ->where('status','p')
                                  ->update(['sickness' => $request->sickness,
                                            'BP' => $request->BP,
                                            'P' => $request->P,
                                            'CBG' => $request->CBG,
                                            'TEMP' => $request->TEMP,
                                            'updated_by' => Auth::user()->id,
                                            'closed_by' => Auth::user()->id,
                                            'prescription' => $request->prescription,
                                            'insurance_id' => $request->insurance_id,
                                            'status' => 'u',
                                            'discount' => $request->discount_amount,
                                            'total_amount' => $request->total_cost
                            ]); 

                                  
                        }

                        return response()->json(['message' => 'Ticket has been successfully closed.']);

                    break;
     


                //if doctor clicks on open button then it will open the ticket
                case 'open':
                            Ticket::where('id',$request->ticket_id)
                                  ->where('status','p')
                                  ->update(['sickness' => $request->sickness,
                                            'updated_by' => Auth::user()->id,
                                            'insurance_id' => $request->insurance_id,
                                            'prescription' => $request->prescription,
                                            'status' => 'a'
                            ]);     

                            return response()->json(['message' => 'Ticket has been successfully updated and transferred to the que.']);         


                    break;


                case 'hold':
                          $this->validate($request,[
                                'sickness' => 'required',
                                'prescription' => 'required'
                          ]);  

                            Ticket::where('id',$request->ticket_id)
                                  ->where('status','p')
                                  ->update(['sickness' => $request->sickness,
                                            'updated_by' => Auth::user()->id,
                                            'prescription' => $request->prescription,
                                            'insurance_id' => $request->insurance_id,
                                            'status' => 'h'
                            ]);     

                            return response()->json(['message' => 'Ticket has been successfully updated and moved to HOLD status.']);         


                    break;

            }
        }
        else
        {
            return response()->json(['unauthorized_access'=>'Sorry, you do not have access to this service. Please contact Admin.']);
        }
    }
```


<a href="#section-4"></a>
##View
Edit file `tickets\read.php` with below codes:
```php
<!-- Products Items -->
                <div class="form-group" id="div-products">
                
                    <label for="results" class="col-md-3 control-label">Products:</label>
                    
                    <div class="col-md-8">
                        <input type="text" name="product_search" id="product_search" placeholder="Search Product" class="form-control">
                        <br>
                        <div class="well bg-grey form-group" id="product_well">
                            @@include('tickets.product_data')
                        </div>

                    </div>

                </div>

<!-- Products ends here -->
    @@endforeach
        <div id="cost-data" class="panel">
            @@include('tickets.read_data')
        </div>
```
Also edit the javascript on `tickets\read.php`:
```php
function add_cost(id)
{
    
    $.ajax({
        url: "@{{url('ticket.products.add')}}",
        type:"POST",
        data:{
            '_token': $('input[name=_token]').val(),
            'ticket_id': '@{{$ticket_id}}',
            'patient_id': '@{{$patient_id}}',
            'product_id': id
        },
        success:function(data){
            console.log(data);
            if(data.html){
                swal({
                        type: 'success',
                        title: 'Yah, Product added !!!',
                        animation: true
                });
            

                $('#cost-data').html(data.html);
            }

            if(data.unauthorized_access){
                swal({
                        type: 'error',
                        title: 'Oops...',
                        text: data.unauthorized_access,
                        animation: true
                });
            }


        },
        error:function(data){
            swal({
                    type: 'error',
                    title: 'Error!!!',
                    text: 'Something went wrong. Please try again later.',
                    animation: true
            });
        }
    });
}


function minus(id){
        $.ajax({
            type: 'POST',
            url: "@{{url('ticket.product.one.remove')}}",
            data:{
                '_token': $('input[name=_token]').val(),
                'charge_id': id,
                'ticket_id':"@{{$ticket_id}}"
            },
            success:function(data)
            {
                console.log(data);
                if(data.unauthorized_access){
                    swal({
                        type: 'error',
                        title: 'Oops...',
                        text: data.unauthorized_access,
                        animation: true
                    });
                }

                if(data.html){
                    swal({
                            type: 'success',
                            title: 'One quantity removed',
                            animation: true
                    });
                

                    $('#cost-data').html(data.html);
                }


            },
            error:function(data){
                swal({
                        type: 'error',
                        title: 'Error!!!',
                        text: 'Something went wrong. Please try again later.',
                        animation: true
                });     
            }
        });
    }



function remove(id){
        $.ajax({
            type: 'POST',
            url: "@{{url('ticket.product.remove')}}",
            data:{
                '_token': $('input[name=_token]').val(),
                'charge_id': id,
                'ticket_id':"@{{$ticket_id}}"
            },
            success:function(data)
            {
                console.log(data);
                if(data.unauthorized_access){
                    swal({
                        type: 'error',
                        title: 'Oops...',
                        text: data.unauthorized_access,
                        animation: true
                    });
                }

                if(data.html){
                    swal({
                            type: 'success',
                            title: 'Product removed.',
                            animation: true
                    });
                

                    $('#cost-data').html(data.html);
                }


            },
            error:function(data){
                swal({
                        type: 'error',
                        title: 'Error!!!',
                        text: 'Something went wrong. Please try again later.',
                        animation: true
                });     
            }
        });
    }

    $('#product_search').on('keyup',function(){
        var value = $(this).val();

        $.ajax({
            type:'post',
            url:"@{{url('ticket.products.search')}}",
            data:{
                '_token': $('input[name=_token]').val(),
                'name': value
            },
            success:function(data){
                $('#product_well').html(data.products);
            },
            error:function(data){
                swal({
                        type: 'error',
                        title: 'Error!!!',
                        text: 'Something went wrong. Please try again later.',
                        animation: true
                }); 
            }
        });
    });

</script>
```
Add a new file named `tickets.read_data`, and add below code:
```php 
<?php use App\Http\Controllers\ConfigController; 
$total_amount = 0;
?>    

    <div class="form-group" id="div-cost_breakdown">
    
        <label for="results" class="col-md-3 control-label">Cost Breakdown: </label>
                        
        <div class="col-md-8 form-group">
        @@if(count($charges) > 0)

           <table class="table table-hover table-striped" style="font-size: 10px;">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Product Name</th>
                    <th>QTY</th>
                    <th>Amount</th>
                    <th></th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
            @@foreach($charges as $charge)
            <?php
                // calculate total_amount
                $total_amount = $total_amount + (ConfigController::get_product_price($charge->price_id) * $charge->quantity);
            ?>
                <tr>
                    <td>@{{$charge->id}}</td>
                    <td>@{{ConfigController::get_product_name($charge->price_id)}}</td>
                    <td>@{{$charge->quantity}}</td>
                    <td>@{{ConfigController::get_product_price($charge->price_id) * $charge->quantity.' FJD'}}</td>
                    <td><span class="btn btn-xs btn-warning" onclick="minus(@{{$charge->id}});"><span class="fa fa-minus"></span></span></td>
                    <td><span class="btn btn-xs btn-danger" onclick="remove(@{{$charge->id}});"><span class="fa fa-trash"></span></span></td>
                </tr>
            @@endforeach
            </tbody>
           </table>

        @@else
            <div class="alert alert-info">No Charges for now.</div>
        @@endif
        </div>
    

    </div>


    <div class="form-group has-error" id="div-discount_amount" style="display: none;">
        <label for="discount_amount" class="col-md-3 control-label">Discount Amount ($)</label>

        <div class="col-md-8">
            <input id="discount_amount" type="text" class="form-control" name="discount_amount"  value="0">

            
                <span class="help-block">
                    <strong id="error_discount_amount"></strong>
                </span>
            
        </div>
    </div>



    <div class="form-group has-success" id="div-total_cost" >
        <label for="total_cost" class="col-md-3 control-label">Total Cost ($)</label>

        <div class="col-md-8">
            <input id="total_cost" type="text" class="form-control" name="total_cost" readonly="readonly" value="@{{$total_amount}}">
            <input id="total_amount" type="hidden" class="form-control" name="total_amount" readonly="readonly" value="@{{$total_amount}}">

            
                <span class="help-block">
                    <strong id="error_total_cost"></strong>
                </span>
            
        </div>
    </div>

```
Create `tickets\product_data.blade.php` and add below codes:
```php


@@if(count($products) > 0)

    <div class="row" style="font-size: 10px;">
    @@foreach($products as $product)
        <div class="col-md-3 col-sm-2 col-lg-2 col-xs-6">
            <button onclick="add_cost(@{{$product->id}});" type="button" class="btn btn-xs btn-primary" style="text-align: center; width: 100px; word-wrap: break-word; height:100px; margin-top: 10px;">@{{$product->name}} <br> @{{$product->amount}}</button>
        </div>
    @@endforeach
    </div>  

@@else
    <div class="alert alert-danger">No products defined.</div>
@@endif

                       
```

