#Version 5.3.4 FRCS XML Upload
---
> {info} This feature is released to close all tickets which are on processing state. If ticket are not closed that means the invoice was not generated by FRCS and you can unlock the tickets

<br>
<br>
- [View](#section-1)
- [Route](#section-2)
- [Controller](#section-3)


<a name="section-1"></a>
## View
Make below change in `layouts/app.php`
```php 
        @@if(ConfigController::check_privilege('ACCESS_UNPROCESS_TICKET'))                                 
            <li><a href="@{{url('/xml.upload')}}">FRCS XML Upload</a></li>
        @@endif
```



Create a new folder named `xml` inside `resources/views` folder
<br>
Create a new file named `upload.blade.php`. Below is the content:
```php
@@extends('layouts.app')

@@section('content')
<?php use App\Http\Controllers\ConfigController; ?>
<div class="col-md-offset-2 col-md-8">
	<div class="panel" id="form_style">
	<div id="header">
		<h3>Upload FRCS XML File</h3>
	</div>
		<div class="panel panel-body">
		<hr>
		<form class="form-horizontal" method="POST" id="form" action="@{{url('/xml.upload')}}" enctype="multipart/form-data">
			<!--Name DIV-->
			@{{ csrf_field() }}

            <!-- Loader start -->
              <div id="loader-wrapper">
                <div id="loader"></div>
              </div>
            <!-- Loader End -->

                <div class="alert alert-success" style="display: none;" id="alert_success"></div>
                <div class="alert alert-danger" style="display: none;" id="alert_error"></div>

                <div class="form-group @{{ $errors->has('file') ? ' has-error' : '' }}" id="div-file">
                    <div class="col-md-8 col-md-offset-3">
                      <div class="fileupload fileupload-new" data-provides="fileupload">
                          <span class="btn btn-primary btn-file col-md-9"><span class="fileupload-new"></span>
                          <span class="fileupload-exists"></span><input id='file' type="file" data-toggle="tooltip" name="file" title="Please upload *.xml file ONLY" data-placement="right" accept=".xml" id="fileupload" /></span>
                      </div>
                                  
                    </div>
                    <span class="help-block col-md-8 col-md-offset-3">
                        <strong id="form-errors-file"></strong>
                    </span>
                </div>


                <div class="form-group">
                    <div class="col-md-8 col-md-offset-3">
                        <button type="submit" class="btn btn-success outline col-md-9" id="submit">
                            <i class="fa fa-upload" aria-hidden="true" ></i>
                            Upload XML File
                        </button>
                    </div> 
                </div>  

		</form>



		</div>
	</div>

</div>

<script type="text/javascript">
    $(window).on('load',function(){
        $('#loader-wrapper').fadeOut('slow');

        //when form is submited
      $('#form').submit(function(e){
        //below line prevents page to submit
        e.preventDefault();

        var form = $('#form')[0];
        var formData = new FormData(form);
        var url;
        url = $(this).attr('action');


             
            $.ajax({
                type:'POST',
                data: formData,
                cache:false,
                contentType: false,
                processData: false,
                url:url,

                beforeSend:function()
                {
                    $('#alert_success').fadeOut('slow');
                    $('#alert_error').fadeOut('slow');


                    $('#div-file').removeClass('has-error');
                    $('#form-errors-file').html('');

                    $('#submit').addClass('loading');
                },
                success:function(data)
                {
                    console.log(data);

                    if(data.success)
                    {
                        $('#submit').removeClass('loading');

                        $('#alert_success').html(data.success);

                        $('#alert_success').fadeIn('slow');
                    }

                    if(data.error)
                    {
                        $('#submit').removeClass('loading');
                        
                        $('#alert_error').html(data.error);

                        $('#alert_error').fadeIn('slow');                        
                    }

                },
                error:function(data)
                {
                    $('#submit').removeClass('loading');

                    console.log(data.responseText);
                    var obj = jQuery.parseJSON(data.responseText);


                    if(obj.file){
                      $('#div-file').addClass('has-error');
                      $('#form-errors-file').html(obj.file);
                    }
                }
          

            });//AJAX end

        });

    });
</script>
@@endsection
```
<br>

Create a new file named `data.blade.php`. Below is the content:
```php
<div class="col-md-8 col-md-offset-2">
	@@if($warning <> '')
		<div class="alert alert-danger">@{!! $warning !!}</div>
	@@endif

	@@if($success <> '')
		<div class="alert alert-success">@{!! $success !!}</div>
	@@endif

	@@if($info <> '')
		<div class="alert alert-info">@{!! $info !!}</div>
	@@endif
</div>
```

<a name="section-2"></a>
## Route
Now add below routes in `routes/web.php`
```php
//FRCS XML Routes 
Route::get('xml.upload','ConfigController@upload_xml');
Route::post('xml.upload','ConfigController@upload_xml_file');
```

<a name="section-3"></a>
## Controller
Inside `ConfigController`, Below codes will go.
```php

    public function upload_xml()
    {
    	    if(ConfigController::check_privilege('ACCESS_UNPROCESS_TICKET'))
    	    {
    			return view('xml.upload');
    	    }
    	    else
    	    {
    	        return view('errors.not_authorized');
    	    }
    }


    public function upload_xml_file(Request $request)
    {
    	    if(ConfigController::check_privilege('ACCESS_UNPROCESS_TICKET'))
    	    {
    	    		$this->validate($request,['file' => 'required']);

    	    		$info = '';
    	    		$success = '';
    	    		$warning = '';

    				$xmlString = Input::file('file');
					$xml = simplexml_load_file($xmlString);
					
					$header = false;
					$response = '';
					
					foreach($xml as $invoices){
						$tickets = '';
						//Find ticket number and see if it is on processing status
						
						$tickets = Ticket::where('id',$invoices->PosInvoiceNumber)
										->where('status','x')
										->where('invoice_type',$invoices->InvoiceType)
										->where('transaction_type',$invoices->TransactionType)
										->where('tax_invoice_number',null)
										->get();
						
						if(count($tickets) == 1){

							$date = date_create($invoices->DateAndTimeOfPos);
							$updated_at = date_format($date,"Y-m-d H:i:s");//2019-05-19 15:47:47

							$TaxItems = $invoices->TaxItems;
							$TaxItem = $TaxItems->TaxItem;
							

							try{
								$commit = Ticket::find($invoices->PosInvoiceNumber);
								$commit->updated_by = Auth::user()->id;
								$commit->closed_by = Auth::user()->id;
								$commit->tax_invoice_number = $invoices->InvoiceNumber;
								$commit->tax_amount = $TaxItem->Amount;
								$commit->tax = 'y';
								$commit->status = 'c';
								$commit->insurance_id = ConfigController::get_patient_insurance_id($commit->patient_id);
								$commit->payment_type = $invoices->PaymentMethod;
	            				//$commit->email_sent = ConfigController::patient_has_email($commit->patient_id);
	            				$commit->updated_at = $updated_at;
								$commit->save();
								$success.='Ticket # '.$invoices->PosInvoiceNumber.' is Closed now.<br>';
							}
							catch(\Exception $e)
							{
													Log::Info(' ');
							Log::Info('----------FRCS Ticket Not Updated-------------');
							Log::Error($e);
							Log::Info('----------FRCS Ticket Not UpdateD END-------------');	
							}

							
						}
						else
						{
							$info.='Ticket # '.$invoices->PosInvoiceNumber.' not on Processing Status.<br>';
						}
					}//End Foreach for XML 


					$checks = Ticket::select('id')->where('status','x')->where('tax_invoice_number',null)->get();

					if(count($checks) > 0){
						foreach ($checks as $check) 
						{
							$warning.= 'Ticket # '.$check->id.' are still on processing status.<br>';
						}
					}

				    $html = view('xml.data',compact('info','warning','success'))->render();	

			return response()->json(['html' => $html]);
					
    	    }
    	    else
    	    {
    			return response()->json(['unauthorized_access'=>'Sorry, you do not have access to this service. Please contact Admin.']);
    	    }
    }
```