#Version 2.4.0.0
---

- [Overview](#section-1)
- [Features](#section-2)
	- [Invoice DB](#section-3)
	- [Subscription Script](#section-4)
	- [Controllers](#section-5)
	- [PDF](#section-6)
	- [Email](#section-7)



##Overview
> {info} For version 2.3.0.0, Bugs and patches on the current platform


<a name="section-2"></a>
## Bugs Fixed
<li>Invoice DB Fixed</li>
<li>Susbscription Script</li>
<li>Controllers</li>
<li>PDF Template Update</li>

<a name="section-3"></a>
## Invoice DB
Make nullable to all invoice and transaction table feilds


<a name="section-3"></a>
## Subscription Script
Change app/console/command/raise_subscription_invoice.php file.
```php
//declare EmailController on the top
use App\Http\Controllers\EmailController;

//online 85 add below time so that pos time and created by  is also captured
$invoice->pos_time = date('Y-m-d H:i:s');
$invoice->created_by = 'CLI';

//on line 147 add below line
//send email to clients to payup the funds and advise the duedate
EmailController::raise_invoice($invoice->id);

```


<a name="section-4"></a>
## Controller
Add new function in EmailController.php
```php
    public static function raise_invoice($id)
    {
        $invoice = Invoice::find($id);

        Log::channel('cron_raise_invoice')->info('Working on invoice # '.$invoice->uuid.'. Invoice Type:'.$invoice->invoice_type);

        //PDF Starts
        $invoice_type = $invoice->invoice_type;
        $status = $invoice->status;
        $url = $invoice->url;
        $transaction_type = $invoice->transaction_type;
        $total_amount = $invoice->total_amount;
        $due_date = $invoice->due_date;
        $payment_type = $invoice->payment_type;
        $status = $invoice->status;
        $client_id = $invoice->client_id;
        $client = Client::find($client_id);
        $created_at = $invoice->created_at;
        $updated_at = $invoice->updated_at;
        $sdc_time = $invoice->sdc_time;
        $pos_time = $invoice->pos_time;
        $sdc_invoice_no = $invoice->sdc_invoice_no;
        $invoice_counter = $invoice->invoice_counter;

        $taxs = Tax::where('invoice_id', $invoice->id)->get();
        $total_tax = Tax::where('invoice_id', $invoice->id)->sum('tax');
        $charges = Charge::where('invoice_id', $invoice->id)->get();
        $transactions = Transaction::where('invoice_id',$invoice->id)->get();
        $transaction_bal = Transaction::where('invoice_id',$invoice->id)->sum('amount');    


        //email body data
        $data = array(
                    'invoice_type'  => $invoice_type,
                    'status'  => $status,
                    'url'  => $url,
                    'transaction_type'  => $transaction_type,
                    'total_amount'  => $total_amount,
                    'due_date'  => $due_date,
                    'payment_type'  => $payment_type,
                    'client'  => $client,
                    'created_at'  => $created_at,
                    'updated_at'  => $updated_at,
                    'taxs'  => $taxs,
                    'total_tax'  => $total_tax,
                    'sdc_time'  => $sdc_time,
                    'pos_time'  => $pos_time,
                    'sdc_invoice_no'  => $sdc_invoice_no,
                    'invoice_counter'  => $invoice_counter,
                    'invoice'  => $invoice,
                    'charges'  => $charges,
                    'transaction_bal'  => $transaction_bal,
                    'transactions'  => $transactions,

        );

        $pdf = PDF::loadView('pdf.frcs_bootstrap',array('data'=>$data));

        $client = Client::find($invoice->client_id);
        $email = $client->email;

        Log::channel('cron_raise_invoice')->info('Sending email to '.$email);

        try{

                $emails_data = array(   
                                    'email' => $email,
                                    'name' => $client->contact_name,
                                    'id' => $invoice->uuid,
                                    'cc_name' => config('app.name'),
                                    'cc_email'=> config('app.email')
                                );




                Mail::send('emails.new_invoice', array('data'=>$data), function($message) use ($emails_data,$pdf)
                {    
                    $message->to($emails_data['email'],$emails_data['name'])
                            ->cc($emails_data['cc_email'],$emails_data['cc_name'])
                            ->subject('Customer Payment Notice - Invoice #'.$emails_data['id'])
                            ->attachData($pdf->output(), "Customer Invoice #".$emails_data['id'].".pdf");    
                });

                $status_email = false;

        }//try ends here
        catch(\Exception $e)
        {
                $email = new Email;
                $email->type = 'Invoice';
                $email->type_id = $invoice->id;
                $email->name = 'Raise Invoice';
                $email->sent = 'n';
                $email->save();

                Log::channel('cron_raise_invoice')->ERROR('Email not sent for invoice ID '.$invoice->uuid);
                Log::channel('cron_raise_invoice')->ERROR($e);
                Log::channel('cron_raise_invoice')->ERROR('END ERROR LOGS for Invoice ID '.$invoice->uuid);

                $status_email = true;
        }//catch ends here


        if($status_email == false){

            $email = new Email;
            $email->type = 'Invoice';
            $email->type_id = $invoice->id;
            $email->name = 'Raise Invoice';
            $email->sent = 'y';
            $email->save();

            $update_invoice = '';
            $update_invoice = Invoice::find($invoice->id);
            $update_invoice->send_email = '';
            $update_invoice->save();
        }

        //EMAIL SENDING FINISHES        
    }
```

Add static function in ConfigController.php
```php
    public static function get_userTIN($user_id)
    {
    	if($user_id == '')
    	{
    		return '';
    	}
    	if($user_id == 'CLI')
    	{
    		return '';
    	}
    	else
    	{
    		$user = User::find($user_id);
    		return $user->tin_number;
    	}
    }

```

Have to add below line where ever invoice is being created in InvoiceController.php
```php
$invoice->created_by = Auth::user()->id;
```


<a name="section-5"></a>
## PDF
Make change in resources/pdf/frcs_bootstrap.php
```php
      @@if($data['client']->tin_number <> '')
        Buyer TIN: @{{$data['client']->tin_number}}<br>
      @@endif
```

<a name="section-6"></a>
## Email
Make change in resources/emails/new_invoice.php
```php 
This is a notice that an invoice has been generated on @{{$data['invoice']->created_at}}.


Due Date: @{{$data['invoice']->due_date}} <br>
```
