#Version 1.1.1
---

- [Overview](#section-1)
- [Features](#section-2)
- [Procedures](#section-3)
	- [Licence](#section-4)



##Overview
> {info} For version 1.1.1, licence product has been introduced and password expiry has been implemented.


<a name="section-2"></a>
## Features Introduced
<li>Licence</li>
<li>Password Expiry</li>

<a name="section-3"></a>
## Migration

Run `php artisan migrate`
<br>
This command will create licence table and add new columns in users table.
<br>
Add new columns in the Model in User & Licence file.

Now make changes in `AuthenticatesUsers.php` 
Copy & paste below codes:
```php
    protected function authenticated(Request $request, $user)
    {
        switch (Auth::user()->role_id) {
            case '1':
                $user = new Logins();
                $user->ip = $request->getClientIp();
                $user->login_type = 'WEB';
                $user->user_id = Auth::user()->id;
                $user->login_date = date('d-m-Y h:i:s A');
                $user->save();

                break;

            case '2':
                $user = new Logins();
                $user->ip = $request->getClientIp();
                $user->login_type = 'WEB';
                $user->user_id = Auth::user()->id;
                $user->login_date = date('d-m-Y h:i:s A');
                $user->save();
                break;  

            case '3':
                $user = new Logins();
                $user->ip = $request->getClientIp();
                $user->login_type = 'API';
                $user->user_id = Auth::user()->id;
                $user->login_date = date('d-m-Y h:i:s A');
                $user->save();
                break;         
        }


        //Check password expiry
        if(ConfigController::check_password_expiry(Auth::user()->id))
        {
            $password = User::find(Auth::user()->id);
            $password->reset = 'on';
            $password->save();
        }


    }
```

<br>
ConfigController
```php
	public function view_licence(Request $request){
	    if(ConfigController::check_privilege('ACCESS_LICENCE_MENU'))
	    {
			$licences = Licence::all();

			if($request->ajax()) 
            {
                $view = view('licence.data',compact('licences'))->render();

                return response()->json(['html'=>$view]);
            }

			return view('licence.list',compact('licences'));
	    }
	    else
	    {
	        return view('errors.not_authorized');
	    }
	}

	public function add_licence(Request $request)
	{
	    if(ConfigController::check_privilege('ACCESS_LICENCE_MENU'))
	    {
	    	$this->validate($request,[
	    			'licence_type'   	  =>		'required',
	    			'number_authorized'   =>		'required'
	    		]);

	    	try
	    	{

	    		$licence = new Licence;
				$licence->type = $request->licence_type;
				$licence->number_allowed = $request->number_authorized;
				$licence->updated_by = Auth::user()->id;
				$licence->created_by = Auth::user()->id;
				$licence->save();

				return response()->json(['success'=>'Licence added successfully.']);

	    	}
	    	catch(\Exception $e)
	    	{
	    		Log::ERROR('=============ADD LICENCE ERROR ================');
	    		Log::ERROR($e);
	    		Log::ERROR('=============ADD LICENCE ERROR END ================');
	    		return response()->json(['error'=>'Sorry, Something went wrong. Please contact Admin.']);
	    	}

	    }
	    else
	    {
			return response()->json(['unauthorized_access'=>'Sorry, you do not have access to this service. Please contact Admin.']);
	    }
	}


	public function edit_licence(Request $request)
	{
	    if(ConfigController::check_privilege('ACCESS_LICENCE_MENU'))
	    {
	    	$this->validate($request,[
	    			'licence_type'   	  =>		'required',
	    			'number_authorized'   =>		'required'
	    		]);

	    	try
	    	{

	    		$licence = Licence::find($request->id);
				$licence->type = $request->licence_type;
				$licence->number_allowed = $request->number_authorized;
				$licence->updated_by = Auth::user()->id;
				$licence->save();

				return response()->json(['success'=>'Licence edited successfully.']);

	    	}
	    	catch(\Exception $e)
	    	{
	    		Log::ERROR('=============EDIT LICENCE ERROR ================');
	    		Log::ERROR($e);
	    		Log::ERROR('=============EDIT LICENCE ERROR END ================');
	    		return response()->json(['error'=>'Sorry, Something went wrong. Please contact Admin.']);
	    	}

	    }
	    else
	    {
			return response()->json(['unauthorized_access'=>'Sorry, you do not have access to this service. Please contact Admin.']);
	    }
	}



	public function delete_licence(Request $request)
	{
	    if(ConfigController::check_privilege('ACCESS_LICENCE_MENU'))
	    {

	    	try
	    	{

	    		$licence = Licence::find($request->id);
				$licence->updated_by = Auth::user()->id;
				$licence->save();//update
				$licence->delete();//delete

				return response()->json(['success'=>'Licence edited successfully.']);

	    	}
	    	catch(\Exception $e)
	    	{
	    		Log::ERROR('=============Delete LICENCE ERROR ================');
	    		Log::ERROR($e);
	    		Log::ERROR('=============Delete LICENCE ERROR END ================');
	    		return response()->json(['error'=>'Sorry, Something went wrong. Please contact Admin.']);
	    	}

	    }
	    else
	    {
			return response()->json(['unauthorized_access'=>'Sorry, you do not have access to this service. Please contact Admin.']);
	    }
	}

	public static function check_licence($type)
	{
		$licences = Licence::select('number_allowed')->where('type',$type)->get();

		$number_allowed = 0;
		if(count($licences) == '1')
		{
			foreach($licences as $licence)
			{
				$number_allowed = $licence->number_allowed;
				return $number_allowed;
			}

			
		}
	}


	public static function check_password_expiry($user_id)
	{

		$days = ConfigController::check_licence('password');

		$user = User::find($user_id);

		$password_changed_at = $user->password_changed_at;

		$password_expiry = date('Y-m-d', strtotime($password_changed_at. ' + '.$days.' day'));

		$today = date("Y-m-d");

		if($password_expiry >= $today){
			return true;
		}
		else{
			return false;
		}
	}
```
<br>

Add below routes on `web.php` route
```php

//Licence
Route::get('/licence.list','ConfigController@view_licence');
Route::post('/licence.add','ConfigController@add_licence');
Route::post('/licence.edit','ConfigController@edit_licence');
Route::post('/licence.delete','ConfigController@delete_licence');
```