# Installation

---

- [Installation](#section-1)
- [Database](#section-2)
    - [Configuration](#section-2)
    - [Inserting Data in DB](#section-3)

<a name="section-1"></a>
## Installation - Cloud Dev
Copy and paste the project on host. Unzip the project.
<br>
I'm using xampp so i will be pasting the unzip folder inside `xampp\htdocs` folder
<br>
Now open `cmd` and go to the folder where your project is. Please note that you will to go to this folder `path\to\project\local\`. Why `local` ? because all project files are in local folder.
<br>
Run `composer update`
<br>
<a name="section-2"></a>
##Database
Enter DB `ip,name,password` in `config\database.php` file.
<br><br>
Go to `app\providers\AppServiceProvider` and edit the below info
```php
//put this on top
use Illuminate\Support\ServiceProvider;
```
add this function inside `AppServiceProvider class`
```php
public function boot()
{
    Schema::defaultStringLength(191);
}
```
This is added so that there is no issue with primary keys.
<br><br>
On cmd, run `php artisan migrate` so that all tables are created. 
<br><br>

<a name="section-3"></a>
###Inserting Data in DB
Insert data by using below sql
```sql
INSERT INTO `users` (`id`, `name`, `email`, `password`, `role_id`, `status`, `remember_token`, `created_at`, `updated_at`, `deleted_at`, `created_by`, `updated_by`, `last_login`, `ip`, `reset`) VALUES
(1, 'Kaushik Kumar', 'djkaushiksk1@gmail.com', '$2y$10$YsHaPy9Mfna6uH.sgnfH4.Pg2BWpv7w.EWeCMvb7cEZnHLYwn5VBy', '1', 'a', 'ztA4XK3nDneu4D86QIZlDce7dGg5S9dfCedYw0Z24yS04yJ26fERKKxjTwlc', NULL, '2017-10-16 22:38:03', NULL, '', NULL, '2017-10-17 10:38:03', '::1', 'off');
```
<br>
Add below codes in Login Controller
```php
use \Illuminate\Http\Request;
    public function credentials(Request $request)
    {
        return [
            'email' => $request->email,
            'password' => $request->password,
            'status' => 'a',
        ];
    }
```

<br>
Insert below data in Privilege table
```sql
INSERT INTO `privileges` ( `name`, `status`, `description`, `created_by`, `updated_by`, `created_at`, `updated_at`, `deleted_at`) VALUES
('ACCESS_CONFIG_MENU', 'a', 'View Configuration dropdown Menu', '8', '8', '2017-08-14 23:23:49', '2017-08-14 23:23:49', NULL),
('ACCESS_LIST_ROLE', 'a', 'List and Search Roles.Requires ACCESS_CONFIG_MENU', '8', '8', '2017-08-14 23:24:50', '2017-08-14 23:24:50', NULL),
('ACCESS_LIST_PRIVILEGES', 'a', 'List and Search Privileges. .Requires ACCESS_CONFIG_MENU', '8', '8', '2017-08-14 23:25:53', '2017-08-14 23:25:53', NULL),
('ACCESS_ADD_PRIVILEGES', 'a', 'Add new Privileges. Requires ACCESS_CONFIG_MENU, ACCESS_LIST_PRIVILEGES', '8', '8', '2017-08-14 23:27:00', '2017-08-14 23:27:00', NULL),
('ACCESS_ADD_ROLES', 'a', 'Add new Roles. Requires ACCESS_CONFIG_MENU, ACCESS_LIST_ROLES', '8', '8', '2017-08-14 23:27:22', '2017-08-14 23:27:22', NULL),
('ACCESS_ADD_USER', 'a', 'Add new user. Requires', '8', '8', '2017-08-14 23:30:34', '2017-08-14 23:30:34', NULL),
('ACCESS_LIST_USER', 'a', 'List Users', '8', '8', '2017-08-14 23:30:54', '2017-08-14 23:30:54', NULL),
('ACCESS_USER_RESET_PASSWORD', 'a', 'Access to reset password for users', '1', '1', '2017-08-21 02:40:57', '2017-08-21 02:40:57', NULL),
('ACCESS_USER_EDIT_PROFILE', 'a', 'Access to edit user profile', '1', '1', '2017-08-21 02:47:28', '2017-08-21 02:47:28', NULL),
('ACCESS_USER_DELETE_PROFILE', 'a', 'Access to delete user profile', '1', '1', '2017-08-21 02:47:50', '2017-08-21 02:47:50', NULL),
('ACCESS_ADD_PRIVILEGES_TO_ROLES', 'a', 'Add Privileges to Roles', '1', '1', '2017-08-22 07:39:51', '2017-08-22 07:39:51', NULL),
('ACCESS_SEARCH_ROLES', 'a', 'Access to search roles', '1', '1', '2017-08-24 23:47:35', '2017-08-24 23:47:35', NULL),
('ACCESS_SEARCH_PRIVILEGES', 'a', 'Access to search privileges', '1', '1', '2017-08-25 00:04:49', '2017-08-25 00:04:49', NULL),
('ACCESS_EDIT_USER', 'a', 'Access to edit user details and roles', '1', '1', '2017-08-25 00:24:28', '2017-08-25 00:24:28', NULL),
('ACCESS_RESTORE_USER', 'a', 'Restore User', '1', '1', '2017-08-25 04:02:38', '2017-08-25 04:02:38', NULL),
('ACCESS_SEARCH_USER', 'a', 'Search User', '1', '1', '2017-08-25 09:46:15', '2017-08-25 09:46:15', NULL),
('ACCESS_JAVASCRIPT_LOGS', 'a', 'Displays javascript logs', '1', '1', '2017-09-25 23:04:15', '2017-09-25 23:04:15', NULL);
```
<br><br>
Insert Roles
```sql
INSERT INTO `roles` (`id`, `name`, `status`, `description`, `created_by`, `updated_by`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 'Admin', 'a', 'Have access to all configuration and admin access.\r\nAdmin won''t be able to view any ticket.', '1', '1', '2017-08-14 04:54:49', '2017-08-14 04:54:49', NULL),
(2, 'Doctor (Admin)', 'a', 'Doctor will have rights to Add branches, users,patients and tickets. Can also read, close ticket and update/remove users.', '1', '1', '2017-08-14 05:02:51', '2017-08-14 05:02:51', NULL),
(3, 'Doctor', 'a', 'Can open, read, and close Ticket.', '1', '1', '2017-08-14 10:16:22', '2017-08-14 10:16:22', NULL),
(4, 'Reception', 'a', 'Can Create , Close Ticket.\r\nCannot view past history of the patient', '1', '1', '2017-08-14 10:23:39', '2017-08-14 10:23:39', NULL);

```

Inserting Data in Mapping Table
```sql
INSERT INTO `privileges_mapping` (`role_id`, `privilege_id`, `created_by`, `updated_by`, `created_at`, `updated_at`, `deleted_at`) VALUES
('1', '2', '1', '1', '2017-08-14 15:57:26', '2017-08-14 15:57:26', NULL),
('1', '3', '1', '1', '2017-08-15 10:24:18', '2017-08-15 10:24:18', NULL),
('1', '4', '1', '1', '2017-08-15 10:30:22', '2017-08-15 10:30:22', NULL),
('1', '5', '1', '1', '2017-08-15 12:59:18', '2017-08-15 12:59:18', NULL),
('1', '6', '1', '1', '2017-08-15 13:11:28', '2017-08-15 13:11:28', NULL),
('1', '7', '1', '1', '2018-06-05 21:43:12', '2018-06-05 21:43:12', NULL),
('1', '8', '1', '1', '2018-06-05 21:43:14', '2018-06-05 21:43:14', NULL),
('1', '9', '1', '1', '2018-06-05 21:43:16', '2018-06-05 21:43:16', NULL),
('1', '10', '1', '1', '2018-06-05 21:43:17', '2018-06-05 21:43:17', NULL),
('1', '11', '1', '1', '2018-06-05 21:43:17', '2018-06-05 21:43:17', NULL),
('1', '12', '1', '1', '2018-06-05 21:43:17', '2018-06-05 21:43:17', NULL),
('1', '13', '1', '1', '2018-06-05 21:43:17', '2018-06-05 21:43:17', NULL),
('1', '14', '1', '1', '2018-06-05 21:43:17', '2018-06-05 21:43:17', NULL),
('1', '15', '1', '1', '2018-06-05 21:43:17', '2018-06-05 21:43:17', NULL),
('1', '16', '1', '1', '2018-06-05 21:43:17', '2018-06-05 21:43:17', NULL),
('1', '17', '1', '1', '2018-06-05 21:43:17', '2018-06-05 21:43:17', NULL),
('1', '18', '1', '1', '2018-06-05 21:43:17', '2018-06-05 21:43:17', NULL);
```



