<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PrivilegesTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('privileges')->insert([
			
			['name' => 'ACCESS_CONFIG_MENU', 'status' => 'a','description' => 'View Configuration dropdown Menu','created_by' => '8','updated_by' => '8'],
			['name' => 'ACCESS_LIST_ROLE', 'status' => 'a','description' => 'List and Search Roles.Requires ACCESS_CONFIG_MENU','created_by' => '8','updated_by' => '8'],
			['name' => 'ACCESS_LIST_PRIVILEGES', 'status' => 'a','description' => 'List and Search Privileges. .Requires ACCESS_CONFIG_MENU','created_by' => '8','updated_by' => '8'],
			['name' => 'ACCESS_ADD_PRIVILEGES', 'status' => 'a','description' => 'Add new Privileges. Requires ACCESS_CONFIG_MENU, ACCESS_LIST_PRIVILEGES','created_by' => '8','updated_by' => '8'],
			['name' => 'ACCESS_ADD_ROLES', 'status' => 'a','description' => 'Add new Roles. Requires ACCESS_CONFIG_MENU, ACCESS_LIST_ROLES','created_by' => '8','updated_by' => '8'],
			['name' => 'ACCESS_ADD_USER', 'status' => 'a','description' => 'Add new user. Requires','created_by' => '8','updated_by' => '8'],
			['name' => 'ACCESS_LIST_USER', 'status' => 'a','description' => 'List Users','created_by' => '8','updated_by' => '8'],
			['name' => 'ACCESS_USER_RESET_PASSWORD', 'status' => 'a','description' => 'Access to reset password for users','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_USER_EDIT_PROFILE', 'status' => 'a','description' => 'Access to edit user profile','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_USER_DELETE_PROFILE', 'status' => 'a','description' => 'Access to delete user profile','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_ADD_PRIVILEGES_TO_ROLES', 'status' => 'a','description' => 'Add Privileges to Roles','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_SEARCH_ROLES', 'status' => 'a','description' => 'Access to search roles','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_SEARCH_PRIVILEGES', 'status' => 'a','description' => 'Access to search privileges','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_EDIT_USER', 'status' => 'a','description' => 'Access to edit user details and roles','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_RESTORE_USER', 'status' => 'a','description' => 'Restore User','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_SEARCH_USER', 'status' => 'a','description' => 'Search User','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_JAVASCRIPT_LOGS', 'status' => 'a','description' => 'Displays javascript logs','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_CREATE_TICKET', 'status' => 'a','description' => 'Access to create ticket','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_VIEW_ALL_TICKET', 'status' => 'a','description' => 'Access to view all tickets. This access will normally be with Root and Support level','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_CLIENTS_MENU', 'status' => 'a','description' => 'Access to clients menu','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_LIST_CLIENTS', 'status' => 'a','description' => 'Access to view clients','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_ADD_CLIENTS', 'status' => 'a','description' => 'Access to ADD clients','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_LICENCE_MENU', 'status' => 'a','description' => 'Access to create update licence','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_CLIENT_VIEW', 'status' => 'a','description' => 'Access to View, Add, Edit and remove clients','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_ADD_CLIENT', 'status' => 'a','description' => 'Access to Add new clients','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_EDIT_CLIENT', 'status' => 'a','description' => 'Access to Edit Client','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_DELETE_CLIENT', 'status' => 'a','description' => 'Access to delete Client','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_SUBSCRIPTION_VIEW', 'status' => 'a','description' => 'Access to view subscriptions','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_ADD_SUBSCRIPTION', 'status' => 'a','description' => 'Access to Add subscription','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_EDIT_SUBSCRIPTION', 'status' => 'a','description' => 'Access to Edit subscription','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_DELETE_SUBSCRIPTION', 'status' => 'a','description' => 'Access to Delete subscription','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_CLIENT_SUBSCRIPTION', 'status' => 'a','description' => 'Access for clients to view their subscriptions','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_RESTORE_CLIENT', 'status' => 'a','description' => 'Access to restore client','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_ADD_PRODUCT', 'status' => 'a','description' => 'Access to add products','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_LIST_PRODUCT', 'status' => 'a','description' => 'Access to list products','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_EDIT_PRODUCT', 'status' => 'a','description' => 'Access to edit products','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_DELETE_PRODUCT', 'status' => 'a','description' => 'Access to delete products','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_RESTORE_PRODUCT', 'status' => 'a','description' => 'Access to restore products','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_SEARCH_PRODUCT', 'status' => 'a','description' => 'Access to search products','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_RESTORE_SUBSCRIPTION', 'status' => 'a','description' => 'Access to restore subscription','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_LIST_BRAND', 'status' => 'a','description' => 'Access to list brands','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_ADD_BRAND', 'status' => 'a','description' => 'Access to add brands','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_EDIT_BRAND', 'status' => 'a','description' => 'Access to edit brands','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_DELETE_BRAND', 'status' => 'a','description' => 'Access to delete brands','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_RESTORE_BRAND', 'status' => 'a','description' => 'Access to restore brands','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_SEARCH_BRAND', 'status' => 'a','description' => 'Access to search brands','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_VIEW_INVOICE', 'status' => 'a','description' => 'Access to view all invoices','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_ADD_INVOICE', 'status' => 'a','description' => 'Access to add Invoice','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_TELESCOPE', 'status' => 'a','description' => 'Access to telescope','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_DOCUMENTATION', 'status' => 'a','description' => 'Access to the documentation of softwares and patches made','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_RAISE_INVOICE', 'status' => 'a','description' => 'Access to raise invoice','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_INVOICE_CLIENT_VIEW', 'status' => 'a','description' => 'This access will allow you to access only client s own invoices','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_ADD_TRANSACTION', 'status' => 'a','description' => 'Access to add transaction','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_VIEW_TRANSACTION', 'status' => 'a','description' => 'Access to view transaction details','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_INVOICE_SEARCH', 'status' => 'a','description' => 'Access to search invoice','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_TALLY', 'status' => 'a','description' => 'Access to view tally','created_by' => '1','updated_by' => '1'],
			['name' => 'ACCESS_XML_UPLOAD', 'status' => 'a','description' => 'Access to upload XML','created_by' => '1','updated_by' => '1']

        ]);
    }
}
