<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('invoice_id')->nulllable();
            $table->string('brand_id')->nulllable();
            $table->string('amount')->nulllable();
            $table->string('client_id')->nulllable();
            $table->string('bal_before')->nulllable();
            $table->string('bal_after')->nulllable();
            $table->string('invoice_bal_before')->nulllable();
            $table->string('invoice_bal_after')->nulllable();
            $table->string('created_by')->nulllable();
            $table->string('note')->nulllable();
            $table->string('reference_transaction_id')->nulllable();
            $table->string('status')->nulllable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transactions');
    }
}
