<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInvoicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('invoices', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('client_id')->nullable();
            $table->string('status')->nullable();
            $table->string('type')->nullable();
            $table->string('payment_type')->nullable();
            $table->string('total_amount')->nullable();
            $table->string('payment_date')->nullable();
            $table->string('due_date')->nullable();
            $table->string('payee_reference')->nullable();
            $table->string('filename')->nullable();
            $table->string('tax')->nullable();
            $table->string('tax_amount')->nullable();
            $table->string('transaction_type')->nullable();
            $table->string('rollback_id')->nullable();
            $table->string('tax_invoice_number')->nullable();
            $table->string('note')->nullable();
            $table->string('created_by')->nullable();
            $table->string('updated_by')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('invoices');
    }
}
