<?php

use Monolog\Handler\StreamHandler;
use Monolog\Handler\SyslogUdpHandler;

return [

    /*
    |--------------------------------------------------------------------------
    | Default Log Channel
    |--------------------------------------------------------------------------
    |
    | This option defines the default log channel that gets used when writing
    | messages to the logs. The name specified in this option should match
    | one of the channels defined in the "channels" configuration array.
    |
    */

    'default' => env('LOG_CHANNEL', 'errorlog'),

    /*
    |--------------------------------------------------------------------------
    | Log Channels
    |--------------------------------------------------------------------------
    |
    | Here you may configure the log channels for your application. Out of
    | the box, Laravel uses the Monolog PHP logging library. This gives
    | you a variety of powerful log handlers / formatters to utilize.
    |
    | Available Drivers: "single", "daily", "slack", "syslog",
    |                    "errorlog", "monolog",
    |                    "custom", "stack"
    |
    */

    'channels' => [
        'stack' => [
            'driver' => 'stack',
            'channels' => ['daily'],
            'ignore_exceptions' => false,
        ],

        'single' => [
            'driver' => 'single',
            'path' => storage_path('logs/laravel.log'),
            'level' => 'debug',
        ],

        'daily' => [
            'driver' => 'daily',
            'path' => storage_path('logs/laravel.log'),
            'level' => 'debug',
            'days' => 14,
        ],

        'slack' => [
            'driver' => 'slack',
            'url' => env('LOG_SLACK_WEBHOOK_URL'),
            'username' => 'Laravel Log',
            'emoji' => ':boom:',
            'level' => 'critical',
        ],

        'papertrail' => [
            'driver' => 'monolog',
            'level' => 'debug',
            'handler' => SyslogUdpHandler::class,
            'handler_with' => [
                'host' => env('PAPERTRAIL_URL'),
                'port' => env('PAPERTRAIL_PORT'),
            ],
        ],

        'stderr' => [
            'driver' => 'monolog',
            'handler' => StreamHandler::class,
            'formatter' => env('LOG_STDERR_FORMATTER'),
            'with' => [
                'stream' => 'php://stderr',
            ],
        ],

        'syslog' => [
            'driver' => 'syslog',
            'level' => 'error',
        ],

        'errorlog' => [
            'driver' => 'errorlog',
            'level' => 'error',
        ],
        'cron_raise_invoice' => [
            'driver' => 'daily',
            'level' => 'info',
            'path' => storage_path('logs/subscription/cron_raise_invoice.log'),
            'days' => 7,
        ],
        'send_invoice_email' => [
            'driver' => 'daily',
            'level' => 'info',
            'path' => storage_path('logs/send_invoice_email.log'),
            'days' => 7,
        ],
        'cron_over_due_check' => [
            'driver' => 'daily',
            'level' => 'info',
            'path' => storage_path('logs/overdue/cron_over_due_check.log'),
            'days' => 7,
        ],

        'proforma_cron' => [
            'driver' => 'daily',
            'level' => 'info',
            'path' => storage_path('logs/proforma/proforma_cron.log'),
            'days' => 7,
        ],

        'app' => [
            'driver' => 'daily',
            'level' => 'debug',
            'path' => storage_path('logs/app/app.log'),
            'days' => 7,
        ],
    ],

];
