<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class Role extends Model
{
    use SoftDeletes;

	protected $fillable = 
		['name','status','description','created_by','updated_by'
		];

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->hasOne('App\User');
    }

    public function privileges(){
    	return $this->hasMany('App\Privilege_Mapping');
    }

}
