<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use App\Invoice;

class NotifyAdminInvoice extends Notification
{
    use Queueable;

    public $invoice;
    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(Invoice $invoice)
    {
        $this->invoice = $invoice;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['database','mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        // $notifiable->notifications->first();
        $url = url('notifications.invoice.'.$this->invoice->uuid.'.'.$this->id);

        return (new MailMessage)
                    ->subject('Unprocessed Invoice #'.$this->invoice->uuid)
                    ->greeting('Hello Kaushik!')
                    ->line('One of your invoices has been generation for your action!')
                    ->action('View Invoice', $url)
                    ->line('Thank you');
    }

    public function toDatabase($notifiable)
    {
        return [
            'invoice'   =>  $this->invoice
        ];
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
