<?php
    namespace App\Http\Controllers\api;

    use Illuminate\Http\Request;
    use App\Http\Controllers\Controller;
    use Illuminate\Support\Facades\Auth;
    use App\User;
    use Response;
    use Carbon\Carbon;
    use DB;
    use Illuminate\Support\Facades\Log;


    class UserController extends Controller
    {
        protected $log;
        public function __construct()
        {
            $this->log = Log::channel('app');

            $this->middleware('APIkey');
            $this->content = array();
        }

        public function login(Request $request)
        {
            $this->log->info($request); 
            //date 
            $date = date('Y-m-d');
            
                $request->validate([
                    'email'   => 'required',
                    'password'  => 'required'
                ]);


                if(Auth::attempt(['email' => request('email'), 'password' => request('password')]))
                {
                    $this->log->info('User authenticated Successfully...'); 

                    $user = Auth::user();
                    // $this->content['token'] =  $user->createToken('Pizza App')->accessToken;
                    $this->content['token'] = [
                                                    'name'    => Auth::user()->name,
                                                    'email'   => Auth::user()->email,
                                                    'role_id' => Auth::user()->role_id
                                                ];
                    $status = 200;
                }
                else
                {
                    $this->log->error('User authenticated failed...');
                    $this->content['error'] = "Unauthorised";
                    $status = 401;
                }
            

            return response()->json(['content' => $this->content,'status' => $status]);    
        }
     
        public function details()
        {
            return response()->json(['user' => Auth::user()]);
        }

        /**
         * Logout user (Revoke the token)
         *
         * @return [string] message
         */
        public function logout(Request $request)
        {
            if (Auth::check()) 
            {
               
                    // Auth::user()->AauthAcessToken()->delete();
                    Auth::logout();
                    return response()->json([
                        'message' => 'Successfully logged out',
                        'status'  => 200,
                    ]);
            }
            else
            {
                $this->content['error'] = "Unauthorised";
                $status = 401;
                return response()->json(['error' => 'Please login']);
            }
            

        }

            /**
         * Get the authenticated User
         *
         * @return [json] user object
         */
        public function user(Request $request)
        {
            if (Auth::check()) 
            {
                return response()->json(['user' => Auth::user()]);
            }
            else
            {
                return response()->json(['error' => 'Error']);
            }
        }



        public function get_status()
        {
            // $date = date('Y-m-d');
            // $this->log->useDailyFiles(storage_path().'/logs/app_'.request('email').'_'.$date.'.log');
            $this->log->info('User '. request('email').' for get status.'); 
            $this->log->info('DEBUG '.Auth::check()); 
                if (Auth::check()) 
                {
                    $this->log->info('Status is active.');
                    return response()->json(['status' => 200]);
                }
                else
                {
                    $this->log->error('Status is not active.');
                    return response()->json(['status' => 401]);
                }
            
        }

        public function get_menus()
        {
            if (Auth::check()) 
            {
                $status = 200;
                $accesses = DB::table('privileges_mapping  AS r')
                        ->join('privileges AS p', 'p.id', '=', 'r.privilege_id')
                        ->where('r.role_id',Auth::user()->role_id)
                        ->where('p.name','like','APP%')
                        ->where('r.deleted_at',null)
                        ->get();
                      

                foreach ($accesses as $access) 
                {
                   //$content[0] = array($access->name => $access->name);
                   $privileges[$access->name] = $access->name;
                }
                $privileges['code'] = 200;
                
                
                $this->log->info('Sending privileges...');
                // $this->log->info($content);

                 $this->content['privileges'] = json_encode($accesses);

                //exit();
            }
            else
            {
                $this->log->error('Unauthorised. Error Code 401');
                $this->content['error'] = "Unauthorised";
                $status = 401;
            }

            return response()->json(['content' => $this->content,'status' => $status]);
           
        }
    }//End Class

