<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Transaction;
use App\Invoice;
use App\Email;
use Auth;
use Input;


class TransactionController extends Controller
{

	public function __construct()
	{
		$this->middleware('auth');
	}

	public function add_transaction($uuid)
	{
	    if(ConfigController::check_privilege('ACCESS_ADD_TRANSACTION'))
	    {
			$invoice = Invoice::where('uuid',$uuid)
							  ->where('status','!=','p')
							  ->where('frcs_verified','1')
							  ->first();

			$invoice_count = Invoice::where('uuid',$uuid)
							  ->where('status','!=','p')
							  ->where('frcs_verified','1')
							  ->count();


			if($invoice_count == 1)
			{
				//get transactions
				$amount_paid = Transaction::where('invoice_id',$invoice->id)
										   ->sum('amount');

				$amount_left = Transaction::where('invoice_id',$invoice->id)->sum('amount'); 

				if($amount_left == 0){
					return view('transactions.invoice_settled');
				}

				if($amount_left < 0)
				{
					$id = $invoice->id;
					return view('transactions.add',compact('id','uuid','amount_left'));
				}

			}
			else
			{
				return view('invoices.transaction_error');
			}

	    }
	    else
	    {
	        return view('errors.not_authorized');
			// return response()->json(['unauthorized_access'=>'Sorry, you do not have access to this service. Please contact Admin.']);
	    }
	}


	public function add_transaction_post(Request $request,$uuid)
	{
		$this->validate($request,[
			'amount_paid'   => 'required',
			'payment_type'  => 'required'
		]);

		$invoice = Invoice::where('uuid',$uuid)->first();

		$transaction_bal = Transaction::where('invoice_id',$invoice->id)->sum('amount');    

		$check = $transaction_bal + $request->amount_paid;

		if($check <= 0)
		{
			if($request->payment_type <> 'SplitPayment')
			{
				//add transaction
				//check if customer made full payment

				ConfigController::create_transaction($invoice->id,'2',$request->amount_paid,$invoice->client_id,Auth::user()->id,'','','a',null,null,$request->amount_paid,$invoice->invoice_type,$invoice->payment_type,null,null,null,null,null,null,null);



			}//end split payment
			else
			{
				$total_amount = $request->amount_paid;
				$count = $request->count;
				if($count == '2')
	            {
	                //validation
	                $this->validate($request,[
	                    'payment_type1'    =>     'required',
	                    'payment_type2'    =>     'required',
	                    'payment_total1'   =>     'required',
	                    'payment_total2'   =>     'required'
	                ]);

	                $total = $request->payment_total1 + $request->payment_total2;

	                if($total_amount == $total)
	                {
	            		ConfigController::create_transaction($invoice->id,'2',$request->amount_paid,$invoice->client_id,Auth::user()->id,null,null,'a',null,null,$request->amount_paid,$invoice->invoice_type,$request->payment_type,$request->count,$request->payment_type1,$request->payment_type2,null,$request->payment_total1,$request->payment_total2,null);
	                }
	                else
	                {
	                    return response()->json(['errors' => 'Total Amount and amount entered does not match']);
	                }
	            }//end count 2


	            if($count == '3')
	            {
	                //validation
	                $this->validate($request,[
	                    'payment_type1'    =>     'required',
	                    'payment_type2'    =>     'required',
	                    'payment_type3'    =>     'required',
	                    'payment_total1'   =>     'required',
	                    'payment_total2'   =>     'required',
	                    'payment_total3'   =>     'required'
	                ]);

	                $total = $request->payment_total1 + $request->payment_total2 + $request->payment_total3;

	                if($total_amount == $total)
	                {
	                	ConfigController::create_transaction($invoice->id,'2',$request->amount_paid,$invoice->client_id,Auth::user()->id,null,null,'a',null,null,$request->amount_paid,$invoice->invoice_type,$request->payment_type,$request->count,$request->payment_type1,$request->payment_type2,$request->payment_type3,$request->payment_total1,$request->payment_total2,$request->payment_total3);
	                }
	                else
	                {
	                    return response()->json(['errors' => 'Total Amount and amount entered does not match']);
	                }
	            }//end count 3

			}
		}
        else
		{
			return response()->json(['errors' => 'Payment amount cannot be more than amount left']);
		}


		if(Input::get('sendemail')=="on")
		{
			EmailController::send_transaction_email($uuid);
		}

		return response()->json(['success' => 'Payment successful']);
	}

	public function view_transaction($id)
	{
		    if(ConfigController::check_privilege('ACCESS_VIEW_TRANSACTION'))
		    {

				$transaction = Transaction::find($id);

				$emails = Email::where('type','Transaction')->where('type_id',$id)->get();

				return view('transactions.view',compact('transaction','emails'));
		    }
		    else
		    {
		        return view('errors.not_authorized');
		    }
		


	}
}
