<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Product;
use Auth;


/*
PRIVILEGES USED
===================
ACCESS_ADD_PRODUCT
ACCESS_LIST_PRODUCT
ACCESS_EDIT_PRODUCT
ACCESS_DELETE_PRODUCT
ACCESS_RESTORE_PRODUCT
ACCESS_SEARCH_PRODUCT

*/

class ProductController extends Controller
{

	public function __construct(){
		$this->middleware('auth');
	}

    public function add_products(){
    	if(ConfigController::check_privilege('ACCESS_ADD_PRODUCT'))
    	{
    		return view('products.add');
    	}
    	else
    	{
    		return view('errors.not_authorized');
    	}
    }

    public function save_products(Request $request){
    	if(ConfigController::check_privilege('ACCESS_ADD_PRODUCT'))
    	{

    		if($request->type == 'f'){
		    		$this->validate($request,[
		    			'name' => 'required',
		                'amount' => 'required',
		                'type' => 'required',
		                'ledger_type' => 'required',
		    			'labels' => 'required'
		    		]);
		    }
		    else
		    {
		    	$this->validate($request,[
		    			'name' => 'required',
		                'type' => 'required',
                        'ledger_type' => 'required',
		    			'labels' => 'required'
		    	]);
		    }

    		Product::create([
    			'name' => $request->name,
    			'type' => $request->type,
    			'ledger_type' => $request->ledger_type,
    			'labels' => json_encode($request->labels),
                'amount' => $request->amount,
    			'description' => $request->description,
    			'created_by' => Auth::user()->id,
    			'updated_by' => Auth::user()->id

    		]);

    		return response()->json(['message' => 'Product Name: '.$request->name.' has been added.']);
    	}
    	else
    	{
    		return view('errors.not_authorized');
    	} 	
    }


    public function list_products(){
    	if(ConfigController::check_privilege('ACCESS_LIST_PRODUCT'))
    	{
    		$products = Product::all();

    		return view('products.list',compact('products'));
    	}
    	else
    	{
    		return view('errors.not_authorized');
    	}    	

    }


    public function edit_products($id){

    	if(ConfigController::check_privilege('ACCESS_EDIT_PRODUCT'))
    	{
	    	$products  = Product::where('id',$id)->get();

    	}
    	else
    	{
    		return view('errors.not_authorized');
    	}    

    	return view('products.edit',compact('products','id'));

    }

    public function update_products(Request $request){
    	if(ConfigController::check_privilege('ACCESS_EDIT_PRODUCT'))
    	{
    		if($request->type == 'f'){
		    		$this->validate($request,[
		    			'name' => 'required',
		                'amount' => 'required',
		                'type' => 'required',
		                'ledger_type' => 'required',
		    			'labels' => 'required'
		    		]);
		    }
		    else
		    {
		    	$this->validate($request,[
		    			'name' => 'required',
		                'type' => 'required',
		                'ledger_type' => 'required',
		    			'labels' => 'required'
		    	]);
		    }

	    	$product = Product::find($request->id);
	    	$product->name = $request->name;
            $product->type = $request->type;
            $product->ledger_type = $request->ledger_type;
	    	$product->labels = json_encode($request->labels);
            $product->amount = $request->amount;
	    	$product->description = $request->description;
	    	$product->updated_by = Auth::user()->id;
	    	$product->save();

            return response()->json(['message' => 'Product has been updated']);
	    }
	    else
	    {
	    	return view('errors.not_authorized');
	    }

    	return response()->json(['message' => 'Product has been updated.']);
    }


    public function delete_products(Request $request){
    	if(ConfigController::check_privilege('ACCESS_DELETE_PRODUCT'))
    	{
	    	$product = Product::find($request->id);
	    	$product->updated_by = Auth::user()->id;
	    	$product->save();
	    	$product->delete();
	    }
	    else
	    {
	    	return view('errors.not_authorized');
	    }

	    return response()->json(['success']);

    }


    public function restore_products_list(){
    	if(ConfigController::check_privilege('ACCESS_RESTORE_PRODUCT')){
    		$products = Product::onlyTrashed()->get();

    		return view('products.restore_list',compact('products'));
    	}
    	else
    	{
    		return view('errors.not_authorized');
    	}
    }

    public function restore_product(Request $request){
    	if(ConfigController::check_privilege('ACCESS_RESTORE_PRODUCT'))
    	{
    		product::onlyTrashed()->find($request->id)->restore();

    		return response()->json(['success']);
    	}
    	else
    	{
    		return response()->json(['error']);
    	}
    }


    public function products_search(Request $request){
    	if(ConfigController::check_privilege('ACCESS_SEARCH_PRODUCT'))
    	{
    		$products = product::where('name','like','%'.$request->name.'%')->get();

    		return view('products.list',compact('products'));
    	}
    	else
    	{
    		return view('errors.not_authorized');
    	}
    }


    

}
