<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use App\Notification;
use App\User;

class NotificationController extends Controller
{
	public function __construct()
	{
		$this->middleware('auth');
	}


	public function get()
	{
		$user = User::find(Auth::user()->id);
		$notifications = $user->unreadNotifications;
		$count = $user->unreadNotifications->count();



		$view = view('layouts.notification_data',compact('notifications','count'))->render();


		return response()->json(['data' => $view]);
	}

	public function read(Request $request)
	{
		// $notification = Notification::where('read_at','')->find($request->id);
		$user = User::find(Auth::user()->id);
		$notification = $user->unreadNotifications->find($request->id);
		$notification->read_at = now();
		$notification->save();

		
		return response()->json(['response' => 'success']);
	}

	public function getInvoice($uuid,$id)
	{
		$user = User::find(Auth::user()->id);
		$notification = $user->unreadNotifications->find($id);

		if($notification <> '')
		{
			$notification->read_at = now();
			$notification->save();

			return redirect('invoice.view.'.$uuid);
		}
		else
		{
			return abort(419);
		}
	}
}
