<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Invoice;
use App\Client;
use App\Charge;
use App\Tax;
use App\Email;
use App\Transaction;
use PDF;
use Mail;
use Illuminate\Support\Facades\Log;

class EmailController extends Controller
{
	public static function send_email($id)
	{
		$invoice = Invoice::find($id);

		Log::channel('send_invoice_email')->info('Working on invoice # '.$invoice->uuid.'. Invoice Type:'.$invoice->invoice_type);

        //PDF Starts
        $invoice_type = $invoice->invoice_type;
        $status = $invoice->status;
        $url = $invoice->url;
        $transaction_type = $invoice->transaction_type;
        $total_amount = $invoice->total_amount;
        $due_date = $invoice->due_date;
        $payment_type = $invoice->payment_type;
        $status = $invoice->status;
        $client_id = $invoice->client_id;
        $client = Client::find($client_id);
        $created_at = $invoice->created_at;
        $updated_at = $invoice->updated_at;
        $sdc_time = $invoice->sdc_time;
        $pos_time = $invoice->pos_time;
        $sdc_invoice_no = $invoice->sdc_invoice_no;
        $invoice_counter = $invoice->invoice_counter;

        if($invoice->payment_type == 'SplitPayment')
        {
            $payment_type = 'Other';
        }

        $taxs = Tax::where('invoice_id', $invoice->id)->get();
        $total_tax = Tax::where('invoice_id', $invoice->id)->sum('tax');
        $charges = Charge::where('invoice_id', $invoice->id)->get();
        $transactions = Transaction::where('invoice_id',$invoice->id)->get();
        $transaction_bal = Transaction::where('invoice_id',$invoice->id)->sum('amount');	


        if($invoice->invoice_type == 'Copy')
		{
			$charges = Charge::where('invoice_id', $invoice->payee_reference)->get();
			$transactions = Transaction::where('invoice_id',$invoice->payee_reference)->get();
			$transaction_bal = Transaction::where('invoice_id',$invoice->payee_reference)->sum('amount');
		}	

        if($invoice->transaction_type == 'Refund')
        {
            $array_of_ids = [$invoice->id,$invoice->payee_reference];
            $charges = Charge::where('invoice_id', $invoice->payee_reference)->get();
            $transactions = Transaction::whereIn('invoice_id',$array_of_ids)->get();
            $transaction_bal = Transaction::whereIn('invoice_id',$array_of_ids)->sum('amount');
        }

        //email body data
        $data = array(
                    'invoice_type'  => $invoice_type,
                    'status'  => $status,
                    'url'  => $url,
                    'transaction_type'  => $transaction_type,
                    'total_amount'  => $total_amount,
                    'due_date'  => $due_date,
                    'payment_type'  => $payment_type,
                    'client'  => $client,
                    'created_at'  => $created_at,
                    'updated_at'  => $updated_at,
                    'taxs'  => $taxs,
                    'total_tax'  => $total_tax,
                    'sdc_time'  => $sdc_time,
                    'pos_time'  => $pos_time,
                    'sdc_invoice_no'  => $sdc_invoice_no,
                    'invoice_counter'  => $invoice_counter,
                    'invoice'  => $invoice,
                    'charges'  => $charges,
                    'transaction_bal'  => $transaction_bal,
                    'transactions'  => $transactions,

                    );

        $pdf = PDF::loadView('pdf.custom',array('data'=>$data));
         //PDF ends


        //get Client Email Address
        $client = Client::find($invoice->client_id);
        $email = $client->email;

        Log::channel('send_invoice_email')->info('Sending email to '.$email);

        try{

                $emails_data = array(   
                                    'email' => $email,
                                    'name' => $client->contact_name,
                                    'id' => $invoice->uuid,
                                    'cc_name' => config('app.name'),
                                    'cc_email'=> config('app.email')
                                );




                Mail::send('emails.new_invoice', array('data'=>$data), function($message) use ($emails_data,$pdf)
                {    
                    $message->to($emails_data['email'],$emails_data['name'])
                            ->cc($emails_data['cc_email'],$emails_data['cc_name'])
                            ->subject('Customer Invoice #'.$emails_data['id'])
                            ->attachData($pdf->output(), "Customer Invoice #".$emails_data['id'].".pdf");    
                });

                $status_email = false;

        }//try ends here
        catch(\Exception $e)
        {
                $email = new Email;
                $email->type = 'Invoice';
                $email->type_id = $invoice->id;
                $email->name = 'Raise Invoice';
                $email->sent = 'n';
                $email->save();

                Log::channel('send_invoice_email')->ERROR('Email not sent for invoice ID '.$invoice->uuid);
                Log::channel('send_invoice_email')->ERROR($e);
                Log::channel('send_invoice_email')->ERROR('END ERROR LOGS for Invoice ID '.$invoice->uuid);

                $status_email = true;
        }//catch ends here


        if($status_email == false){

            $email = new Email;
            $email->type = 'Invoice';
            $email->type_id = $invoice->id;
            $email->name = 'Raise Invoice';
            $email->sent = 'y';
            $email->save();

            $update_invoice = '';
            $update_invoice = Invoice::find($invoice->id);
            $update_invoice->send_email = '';
            $update_invoice->save();
        }

        //EMAIL SENDING FINISHES

	}

    public function send_email_by_uuid(Request $request)
    {
        $invoice = Invoice::where('uuid',$request->uuid)->first();

        Log::channel('send_invoice_email')->info('Working on invoice # '.$invoice->uuid.'. Invoice Type:'.$invoice->invoice_type);

        //PDF Starts
        $invoice_type = $invoice->invoice_type;
        $status = $invoice->status;
        $url = $invoice->url;
        $transaction_type = $invoice->transaction_type;
        $total_amount = $invoice->total_amount;
        $due_date = $invoice->due_date;
        $payment_type = $invoice->payment_type;
        $status = $invoice->status;
        $client_id = $invoice->client_id;
        $client = Client::find($client_id);
        $created_at = $invoice->created_at;
        $updated_at = $invoice->updated_at;
        $sdc_time = $invoice->sdc_time;
        $pos_time = $invoice->pos_time;
        $sdc_invoice_no = $invoice->sdc_invoice_no;
        $invoice_counter = $invoice->invoice_counter;

        $taxs = Tax::where('invoice_id', $invoice->id)->get();
        $total_tax = Tax::where('invoice_id', $invoice->id)->sum('tax');
        $charges = Charge::where('invoice_id', $invoice->id)->get();
        $transactions = Transaction::where('invoice_id',$invoice->id)->get();
        $transaction_bal = Transaction::where('invoice_id',$invoice->id)->sum('amount');    


        if($invoice->invoice_type == 'Copy')
        {
            $charges = Charge::where('invoice_id', $invoice->payee_reference)->get();
            $transactions = Transaction::where('invoice_id',$invoice->payee_reference)->get();
            $transaction_bal = Transaction::where('invoice_id',$invoice->payee_reference)->sum('amount');
        }   

        if($invoice->transaction_type == 'Refund')
        {
            $array_of_ids = [$invoice->id,$invoice->payee_reference];
            $charges = Charge::where('invoice_id', $invoice->payee_reference)->get();
            $transactions = Transaction::whereIn('invoice_id',$array_of_ids)->get();
            $transaction_bal = Transaction::whereIn('invoice_id',$array_of_ids)->sum('amount');
        }

        //email body data
        $data = array(
                    'invoice_type'  => $invoice_type,
                    'status'  => $status,
                    'url'  => $url,
                    'transaction_type'  => $transaction_type,
                    'total_amount'  => $total_amount,
                    'due_date'  => $due_date,
                    'payment_type'  => $payment_type,
                    'client'  => $client,
                    'created_at'  => $created_at,
                    'updated_at'  => $updated_at,
                    'taxs'  => $taxs,
                    'total_tax'  => $total_tax,
                    'sdc_time'  => $sdc_time,
                    'pos_time'  => $pos_time,
                    'sdc_invoice_no'  => $sdc_invoice_no,
                    'invoice_counter'  => $invoice_counter,
                    'invoice'  => $invoice,
                    'charges'  => $charges,
                    'transaction_bal'  => $transaction_bal,
                    'transactions'  => $transactions,

                    );

        $pdf = PDF::loadView('pdf.custom',array('data'=>$data));
         //PDF ends


        //get Client Email Address
        $client = Client::find($invoice->client_id);
        $email = $client->email;

        Log::channel('send_invoice_email')->info('Sending email to '.$email);

        try{

                $emails_data = array(   
                                    'email' => $email,
                                    'name' => $client->contact_name,
                                    'id' => $invoice->uuid,
                                    'cc_name' => config('app.name'),
                                    'cc_email'=> config('app.email')
                                );


                Mail::send('emails.unpaid', array('data'=>$data), function($message) use ($emails_data,$pdf)
                {    
                    $message->to($emails_data['email'],$emails_data['name'])
                            ->cc($emails_data['cc_email'],$emails_data['cc_name'])
                            ->subject('Customer Invoice #'.$emails_data['id'])
                            ->attachData($pdf->output(), "Customer Invoice #".$emails_data['id'].".pdf");    
                });

                $status_email = false;

        }//try ends here
        catch(\Exception $e)
        {
                $email = new Email;
                $email->type = 'Invoice';
                $email->type_id = $invoice->id;
                $email->name = 'Raise Invoice';
                $email->sent = 'n';
                $email->save();

                Log::channel('send_invoice_email')->ERROR('Email not sent for invoice ID '.$invoice->uuid);
                Log::channel('send_invoice_email')->ERROR($e);
                Log::channel('send_invoice_email')->ERROR('END ERROR LOGS for Invoice ID '.$invoice->uuid);

                $status_email = true;

                return response()->json(['error' => 'Email not sent. Please contact CloudDev support.']);
        }//catch ends here


        if($status_email == false){

            $email = new Email;
            $email->type = 'Invoice';
            $email->type_id = $invoice->id;
            $email->name = 'Raise Invoice';
            $email->sent = 'y';
            $email->save();

            $update_invoice = '';
            $update_invoice = Invoice::find($invoice->id);
            $update_invoice->send_email = '';
            $update_invoice->save();

            return response()->json(['success' => 'Email sent successfully.']);
        }

        //EMAIL SENDING FINISHES
    }


    public static function send_transaction_email($uuid)
    {

        $invoice = Invoice::where('uuid',$uuid)->first();

        //get last transaction
        $last_transaction = Transaction::where('invoice_id',$invoice->id)->orderBy('id','desc')->first();

        Log::channel('send_invoice_email')->info('Working on Transaction # '.$last_transaction->id);

        //PDF Starts
        $invoice_type = $invoice->invoice_type;
        $status = $invoice->status;
        $url = $invoice->url;
        $transaction_type = $invoice->transaction_type;
        $total_amount = $invoice->total_amount;
        $due_date = $invoice->due_date;
        $payment_type = $invoice->payment_type;
        $status = $invoice->status;
        $client_id = $invoice->client_id;
        $client = Client::find($client_id);
        $created_at = $invoice->created_at;
        $updated_at = $invoice->updated_at;
        $sdc_time = $invoice->sdc_time;
        $sdc_invoice_no = $invoice->sdc_invoice_no;
        $invoice_counter = $invoice->invoice_counter;

        $taxs = Tax::where('invoice_id', $invoice->id)->get();
        $charges = Charge::where('invoice_id', $invoice->id)->get();
        $transactions = Transaction::where('invoice_id',$invoice->id)->get();
        $transaction_bal = Transaction::where('invoice_id',$invoice->id)->sum('amount');    


        if($invoice->invoice_type == 'Copy')
        {
            $charges = Charge::where('invoice_id', $invoice->payee_reference)->get();
            $transactions = Transaction::where('invoice_id',$invoice->payee_reference)->get();
            $transaction_bal = Transaction::where('invoice_id',$invoice->payee_reference)->sum('amount');
        }   

        if($invoice->transaction_type == 'Refund')
        {
            $array_of_ids = [$invoice->id,$invoice->payee_reference];
            $charges = Charge::where('invoice_id', $invoice->payee_reference)->get();
            $transactions = Transaction::whereIn('invoice_id',$array_of_ids)->get();
            $transaction_bal = Transaction::whereIn('invoice_id',$array_of_ids)->sum('amount');
        }

        //email body data
        $data = array(
                    'invoice_type'  => $invoice_type,
                    'status'  => $status,
                    'url'  => $url,
                    'transaction_type'  => $transaction_type,
                    'total_amount'  => $total_amount,
                    'due_date'  => $due_date,
                    'payment_type'  => $payment_type,
                    'client'  => $client,
                    'created_at'  => $created_at,
                    'updated_at'  => $updated_at,
                    'taxs'  => $taxs,
                    'sdc_time'  => $sdc_time,
                    'sdc_invoice_no'  => $sdc_invoice_no,
                    'invoice_counter'  => $invoice_counter,
                    'invoice'  => $invoice,
                    'charges'  => $charges,
                    'transaction_bal'  => $transaction_bal,
                    'transactions'  => $transactions,
                    'uuid'  => $uuid,
                    'name'  => $client->contact_name,

                );

        $pdf = PDF::loadView('pdf.transaction',array('data'=>$data));
         //PDF ends


        //get Client Email Address
        $client = Client::find($invoice->client_id);
        $email = $client->email;

        Log::channel('send_invoice_email')->info('Sending email to '.$email);

        try{

                $emails_data = array(   
                                    'email' => $email,
                                    'name' => $client->contact_name,
                                    'id' => $invoice->uuid,
                                    'transaction_id' => $last_transaction->id,
                                    'cc_name' => config('app.name'),
                                    'cc_email'=> config('app.email')
                                );


                Mail::send('emails.transaction_payment', array('data'=>$data), function($message) use ($emails_data,$pdf)
                {    
                    $message->to($emails_data['email'],$emails_data['name'])
                            ->cc($emails_data['cc_email'],$emails_data['cc_name'])
                            ->subject('Customer Invoice #'.$emails_data['id'].' ***PAYMENT#'.$emails_data['transaction_id'].'***')
                            ->attachData($pdf->output(), "Customer Invoice #".$emails_data['id'].".pdf");    
                });

                $status_email = false;

        }//try ends here
        catch(\Exception $e)
        {
                $email = new Email;
                $email->type = 'Transaction';
                $email->type_id = $last_transaction->id;
                $email->name = 'Payment';
                $email->sent = 'n';
                $email->save();

                Log::channel('send_invoice_email')->ERROR('Email not sent for transaction ID '.$last_transaction->id);
                Log::channel('send_invoice_email')->ERROR($e);
                Log::channel('send_invoice_email')->ERROR('END ERROR LOGS for transaction ID '.$last_transaction->id);

                $status_email = true;
        }//catch ends here


        if($status_email == false){

            $email = new Email;
            $email->type = 'Transaction';
            $email->type_id = $last_transaction->id;
            $email->name = 'Payment';
            $email->sent = 'y';
            $email->save();

            $update_invoice = '';
            $update_invoice = Invoice::find($invoice->id);
            $update_invoice->send_email = '';
            $update_invoice->save();
        }

        //EMAIL SENDING FINISHES



    }



    public static function raise_invoice($id)
    {
        $invoice = Invoice::find($id);

        Log::channel('cron_raise_invoice')->info('Working on invoice # '.$invoice->uuid.'. Invoice Type:'.$invoice->invoice_type);

        //PDF Starts
        $invoice_type = $invoice->invoice_type;
        $status = $invoice->status;
        $url = $invoice->url;
        $transaction_type = $invoice->transaction_type;
        $total_amount = $invoice->total_amount;
        $due_date = $invoice->due_date;
        $payment_type = $invoice->payment_type;
        $status = $invoice->status;
        $client_id = $invoice->client_id;
        $client = Client::find($client_id);
        $created_at = $invoice->created_at;
        $updated_at = $invoice->updated_at;
        $sdc_time = $invoice->sdc_time;
        $pos_time = $invoice->pos_time;
        $sdc_invoice_no = $invoice->sdc_invoice_no;
        $invoice_counter = $invoice->invoice_counter;

        $taxs = Tax::where('invoice_id', $invoice->id)->get();
        $total_tax = Tax::where('invoice_id', $invoice->id)->sum('tax');
        $charges = Charge::where('invoice_id', $invoice->id)->get();
        $transactions = Transaction::where('invoice_id',$invoice->id)->get();
        $transaction_bal = Transaction::where('invoice_id',$invoice->id)->sum('amount');    


        //email body data
        $data = array(
                    'invoice_type'  => $invoice_type,
                    'status'  => $status,
                    'url'  => $url,
                    'transaction_type'  => $transaction_type,
                    'total_amount'  => $total_amount,
                    'due_date'  => $due_date,
                    'payment_type'  => $payment_type,
                    'client'  => $client,
                    'created_at'  => $created_at,
                    'updated_at'  => $updated_at,
                    'taxs'  => $taxs,
                    'total_tax'  => $total_tax,
                    'sdc_time'  => $sdc_time,
                    'pos_time'  => $pos_time,
                    'sdc_invoice_no'  => $sdc_invoice_no,
                    'invoice_counter'  => $invoice_counter,
                    'invoice'  => $invoice,
                    'charges'  => $charges,
                    'transaction_bal'  => $transaction_bal,
                    'transactions'  => $transactions,

        );

        $pdf = PDF::loadView('pdf.custom',array('data'=>$data));

        $client = Client::find($invoice->client_id);
        $email = $client->email;

        Log::channel('cron_raise_invoice')->info('Sending email to '.$email);

        try{

                $emails_data = array(   
                                    'email' => $email,
                                    'name' => $client->contact_name,
                                    'id' => $invoice->uuid,
                                    'cc_name' => config('app.name'),
                                    'cc_email'=> config('app.email')
                                );




                Mail::send('emails.new_invoice', array('data'=>$data), function($message) use ($emails_data,$pdf)
                {    
                    $message->to($emails_data['email'],$emails_data['name'])
                            ->cc($emails_data['cc_email'],$emails_data['cc_name'])
                            ->subject('Customer Payment Notice - Invoice #'.$emails_data['id'])
                            ->attachData($pdf->output(), "Customer Invoice #".$emails_data['id'].".pdf");    
                });

                $status_email = false;

        }//try ends here
        catch(\Exception $e)
        {
                $email = new Email;
                $email->type = 'Invoice';
                $email->type_id = $invoice->id;
                $email->name = 'Raise Invoice';
                $email->sent = 'n';
                $email->save();

                Log::channel('cron_raise_invoice')->ERROR('Email not sent for invoice ID '.$invoice->uuid);
                Log::channel('cron_raise_invoice')->ERROR($e);
                Log::channel('cron_raise_invoice')->ERROR('END ERROR LOGS for Invoice ID '.$invoice->uuid);

                $status_email = true;
        }//catch ends here


        if($status_email == false){

            $email = new Email;
            $email->type = 'Invoice';
            $email->type_id = $invoice->id;
            $email->name = 'Raise Invoice';
            $email->sent = 'y';
            $email->save();

            $update_invoice = '';
            $update_invoice = Invoice::find($invoice->id);
            $update_invoice->send_email = '';
            $update_invoice->save();
        }

        //EMAIL SENDING FINISHES        


    }



}
