<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Role;
use Auth;
use App\Privilege;
use Illuminate\Support\Facades\Response;
use App\Privilege_Mapping;
use DB;
use App\User;
use App\Invoice;
use App\Product;
use App\Transaction;
use App\Licence;
use App\Client;
use App\Charge;
use App\Brand;
use Illuminate\Support\Facades\Input;
use Log;
ini_set('max_execution_time', 300); 

class ConfigController extends Controller
{
	public function __construct(){
		$this->middleware('auth');
	}



	/*
	================================================================================
	||							ROLES METHODS Starts 							  ||
	================================================================================
	*/
	public function view_roles(){

		if(ConfigController::check_privilege('ACCESS_LIST_ROLE'))
		{
			switch (Auth::user()->role_id) {
				case '1'://admin
					$roles = Role::all();
					break;
				
				case '2'://admin doctor
					$roles = Role::where('id','<>','1')->get();
					break;

				default:
					return view('errors.not_authorized');
					break;
			}

		}
		else
		{
			return view('errors.not_authorized');
		}
		
		return view('configs.roles', compact('roles'));
	}

	public function add_role(){
		if(ConfigController::check_privilege('ACCESS_ADD_ROLES'))
		{
			return view('configs.add_role');
		}
		else
		{
			return view('errors.not_authorized');
		}
	}

	public function save_role(Request $request){
		if(ConfigController::check_privilege('ACCESS_ADD_ROLES'))
		{
			$this->validate($request,[
				'name' => 'required',
				'description' => 'required',
			]);

			Role::create([
				'name' => $request->name,
				'description' => $request->description,
				'created_by' => Auth::user()->id ,
				'updated_by' => Auth::user()->id,
				'status' => 'a'
			]);
		}
		else
		{
			return view('errors.not_authorized');
		}

		return response()->json(['message' => 'Role added successfully.']);
	}



	public function search_role(Request $request){
		if(ConfigController::check_privilege('ACCESS_SEARCH_ROLES'))
		{
			switch (Auth::user()->role_id) 
			{
				case '1'://admin
					$roles = Role::where('name','like','%'.$request->name.'%')->get();
					break;
				
				case '2'://admin doctor
					$roles = Role::where('id','<>','1')
								 ->where('name','like','%'.$request->name.'%')
								 ->get();
					break;

				default:
					return view('errors.not_authorized');
					break;
			}
		}
		else
		{
			return view('errors.not_authorized');
		}

		return view('configs.roles', compact('roles'));
	}



	/*
	================================================================================
	||							ROLES METHODS end 								  ||
	================================================================================
	*/

	/*
	================================================================================
	||							PRIVILEGES METHODS Starts 						  ||
	================================================================================
	*/

	public function view_privileges(){
		if(ConfigController::check_privilege('ACCESS_LIST_PRIVILEGES'))
		{
			$privileges = Privilege::paginate(15);
		}
		else
		{
			return view('errors.not_authorized');
		}
		

		return view('configs.privileges',compact('privileges'));
	}


	public function add_privilege(){
		if(ConfigController::check_privilege('ACCESS_ADD_PRIVILEGES'))
		{
			return view('configs.add_privilege');
		}
		else
		{
			return view('errors.not_authorized');
		}
	}

	public function save_privilege(Request $request){

		if(ConfigController::check_privilege('ACCESS_ADD_PRIVILEGES'))
		{
			$this->validate($request,[
				'name' => 'required|unique:privileges|alpha_dash',
				'description' => 'required'
			]);

			Privilege::create([
				'name' => $request->name,
				'description' => $request->description,
				'status' => 'a',
				'created_by' => Auth::user()->id,
				'updated_by' => Auth::user()->id
			]);
		}
		else
		{
			return view('errors.not_authorized');
		}

		return response()->json(['message' => 'Privilege added successfully.']);
	}


	public function search_privilege(Request $request){
		if(ConfigController::check_privilege('ACCESS_SEARCH_PRIVILEGES'))
		{
			$privileges = Privilege::where('name','like','%'.$request->name.'%')->paginate(15);
		}
		else
		{
			return view('errors.not_authorized');
		}
		

		return view('configs.privileges',compact('privileges'));
	}


	/*
	================================================================================
	||							PRIVILEGES METHODS ENDS 						  ||
	================================================================================
	*/


	/*
	================================================================================
	||							PRIVILEGES MAPPING Starts 						  ||
	================================================================================
	*/

	public function addPrivilegeToRole($id){

		if(ConfigController::check_privilege('ACCESS_ADD_PRIVILEGES_TO_ROLES'))
		{
			$privileges = Privilege::select('id','name')
								   ->get();	

			$maps = Privilege_Mapping::where('role_id',$id)->get();
		}
		else
		{
			return view('errors.not_authorized');
		}		

		return view('configs.addPrivilegeToRole',compact('privileges','maps','id'));
	}

	public function addPrivilegeToRole_mapping(Request $request){

		if(ConfigController::check_privilege('ACCESS_ADD_PRIVILEGES_TO_ROLES'))
		{	
			$id = $request->role_id;

			// $privilege_id = $request->privilege_id;

			// Privilege_Mapping::create([
			// 	'role_id' => $id,
			// 	'privilege_id' => $privilege_id,
			// 	'created_by' => Auth::user()->id,
			// 	'updated_by' => Auth::user()->id
			// ]);
			$privileges = Privilege::get();

			foreach($privileges as $privilege)
			{
				
				if(Input::get('productCheckbox'.$privilege->id) == 'yes')
				{

					if(!ConfigController::get_role_agreement($id,$privilege->id))
					{

						Privilege_Mapping::create([
							'role_id' => $id,
							'privilege_id' => $privilege->id,
							'created_by' => Auth::user()->id,
							'updated_by' => Auth::user()->id
						]);		

													
					}
				}


				if(Input::get('productCheckbox'.$privilege->id) == 'no')
				{

					if(ConfigController::get_role_agreement_id($id,$privilege->id))
					{
						$map_id = ConfigController::get_role_agreement_id($id,$privilege->id);

						$mapping = Privilege_Mapping::find($map_id);
						$mapping->delete();

															
					}
				}

			}//Privileges End Foreach Statement

			return response()->json(['success' => 'Role updated...']);

		}
		else
		{
			return response()->json(['error' => 'Opps, Something went wrong.']);	
		}

		return redirect('/role.add.privileges.'.$id)->with('message','Privilege added to role successfully.');

	}


	/*
	================================================================================
	||							PRIVILEGES MAPPING ENDS 						  ||
	================================================================================
	*/

	/*
	================================================================================
	||			         PRIVILEGES MAPPING DELETE FUNCTION START 				  ||
	================================================================================
	*/
	public function removePrivilegeFromRole(Request $request){
		Privilege_Mapping::where('id',$request->id)
						 ->forceDelete();

		return response()->json(['success']);
	}


	/*
	================================================================================
	||			         PRIVILEGES MAPPING DELETE FUNCTION END   				  ||
	================================================================================
	*/


/*
This function is used to check privileges and see if it matches or not

*/
	public static function check_privilege($privilege_name){
		$role_id = Auth::user()->role_id;
		// $privileges = DB::table('view_users_mapping')->where('role_id',$role_id)
		// 											 ->where('name', $privilege_name)
		// 											 ->get();

		$privileges = DB::table('privileges_mapping  AS r')
						->join('privileges AS p', 'p.id', '=', 'r.privilege_id')
						->where('r.role_id',$role_id)
						->where('p.name',$privilege_name)
						->where('r.deleted_at',null)
						->get();



		if(count($privileges) == 1){
			return true;
		}else{
			return false;
		}
	}


	public static function get_username($id)
	{

		if($id <> null)
		{
			if($id == 'CLI')
			{
				return 'CLI';
			}
			else
			{
				$users = User::select('name')->where('id',$id)->withTrashed()->get();

				if(count($users) == 1)
				{
					foreach ($users as $user) 
					{
						$username = $user->name;
					}	
					return $username;	
				}

				return '';
			}
			
		}// END NOT NULL
		else
		{
			return '';
		}
		
	}


	public static function get_role($id){
		$privileges = Role::select('id','name')->where('id',$id)->get();

		foreach ($privileges as $privilege) {
			$role_name = $privilege->name;
		}

		return $role_name;
	}	


	public static function get_role_agreement($role_id,$privilege_id)
	{
		$agreement = Privilege_Mapping::where('role_id',$role_id)
							  ->where('privilege_id', $privilege_id)
							  ->get();

		if(count($agreement) == '1'){
			foreach ($agreement as $value) 
			{
				return true;
			}
		}
		else
		{
			return false;
		}
	}

	public static function get_role_agreement_id($role_id,$privilege_id)
	{
		$agreement = Privilege_Mapping::where('role_id',$role_id)
							  ->where('privilege_id', $privilege_id)
							  ->get();

		if(count($agreement) == '1'){
			foreach ($agreement as $value) 
			{
				return $value->id;
			}
		}
		else
		{
			return false;
		}
	}


	public function view_licence(Request $request){
	    if(ConfigController::check_privilege('ACCESS_LICENCE_MENU'))
	    {
			$licences = Licence::all();

			if($request->ajax()) 
            {
                $view = view('licence.data',compact('licences'))->render();

                return response()->json(['html'=>$view]);
            }

			return view('licence.list',compact('licences'));
	    }
	    else
	    {
	        return view('errors.not_authorized');
	    }
	}

	public function add_licence(Request $request)
	{
	    if(ConfigController::check_privilege('ACCESS_LICENCE_MENU'))
	    {
	    	$this->validate($request,[
	    			'licence_type'   	  =>		'required',
	    			'number_authorized'   =>		'required'
	    		]);

	    	try
	    	{

	    		$licence = new Licence;
				$licence->type = $request->licence_type;
				$licence->number_allowed = $request->number_authorized;
				$licence->updated_by = Auth::user()->id;
				$licence->created_by = Auth::user()->id;
				$licence->save();

				return response()->json(['success'=>'Licence added successfully.']);

	    	}
	    	catch(\Exception $e)
	    	{
	    		Log::ERROR('=============ADD LICENCE ERROR ================');
	    		Log::ERROR($e);
	    		Log::ERROR('=============ADD LICENCE ERROR END ================');
	    		return response()->json(['error'=>'Sorry, Something went wrong. Please contact Admin.']);
	    	}

	    }
	    else
	    {
			return response()->json(['error'=>'Sorry, you do not have access to this service. Please contact Admin.']);
	    }
	}


	public function edit_licence(Request $request)
	{
	    if(ConfigController::check_privilege('ACCESS_LICENCE_MENU'))
	    {
	    	$this->validate($request,[
	    			'licence_type'   	  =>		'required',
	    			'number_authorized'   =>		'required'
	    		]);

	    	try
	    	{

	    		$licence = Licence::find($request->id);
				$licence->type = $request->licence_type;
				$licence->number_allowed = $request->number_authorized;
				$licence->updated_by = Auth::user()->id;
				$licence->save();

				return response()->json(['success'=>'Licence edited successfully.']);

	    	}
	    	catch(\Exception $e)
	    	{
	    		Log::ERROR('=============EDIT LICENCE ERROR ================');
	    		Log::ERROR($e);
	    		Log::ERROR('=============EDIT LICENCE ERROR END ================');
	    		return response()->json(['error'=>'Sorry, Something went wrong. Please contact Admin.']);
	    	}

	    }
	    else
	    {
			return response()->json(['unauthorized_access'=>'Sorry, you do not have access to this service. Please contact Admin.']);
	    }
	}



	public function delete_licence(Request $request)
	{
	    if(ConfigController::check_privilege('ACCESS_LICENCE_MENU'))
	    {

	    	try
	    	{

	    		$licence = Licence::find($request->id);
				$licence->updated_by = Auth::user()->id;
				$licence->save();//update
				$licence->delete();//delete

				return response()->json(['success'=>'Licence edited successfully.']);

	    	}
	    	catch(\Exception $e)
	    	{
	    		Log::ERROR('=============Delete LICENCE ERROR ================');
	    		Log::ERROR($e);
	    		Log::ERROR('=============Delete LICENCE ERROR END ================');
	    		return response()->json(['error'=>'Sorry, Something went wrong. Please contact Admin.']);
	    	}

	    }
	    else
	    {
			return response()->json(['unauthorized_access'=>'Sorry, you do not have access to this service. Please contact Admin.']);
	    }
	}

	public static function check_licence($type)
	{
		$licences = Licence::select('number_allowed')->where('type',$type)->get();

		$number_allowed = 0;
		if(count($licences) == '1')
		{
			foreach($licences as $licence)
			{
				$number_allowed = $licence->number_allowed;
				return $number_allowed;
			}

			
		}
	}


	public static function check_password_expiry($user_id)
	{
		// date("Y-m-d H:i:s")

		$days = ConfigController::check_licence('password');

		$user = User::find($user_id);

		$password_changed_at = $user->password_changed_at;

		$password_expiry = date('Y-m-d', strtotime($password_changed_at. ' + '.$days.' day'));

		$today = date("Y-m-d");

		if($password_expiry <= $today){
			return true;
		}
		else
		{
			return false;
		}
	}


	public static function get_clientname($id){
		if($id == '')
		{
			return '';
		}
		
		$client = Client::select('business_name')->find($id);
		return $client->business_name;
	}

	public static function get_productName($id)
	{
		$product = Product::select('name')->find($id);
		return $product->name;
	}


	public static function refund_transaction($id,$invoice_id,$brand_id,$amount,$client_id,$status,$invoice_ref,$invoice_type)
	{
		switch ($brand_id) {
			case '1'://raise invoice
				$transaction = new Transaction;
				$transaction->invoice_id = $invoice_id;
				$transaction->brand_id = '4';
				$transaction->amount = abs($amount);
				$transaction->client_id = $client_id;
				$transaction->reference_transaction_id = $id;
				$transaction->status = $status;
				$transaction->created_by = Auth::user()->id;
				$transaction->note = 'Raise Invoice Reversal';
				$transaction->reference_number = $invoice_ref;
				$transaction->bal_before = ConfigController::get_Client_Bal($client_id,$invoice_type);
		        $transaction->bal_after = ConfigController::get_Client_Bal($client_id,$invoice_type)+abs($amount);
		        $transaction->invoice_bal_before = ConfigController::calculate_invoice_balance_before($invoice_id);
		        $transaction->invoice_bal_after = ConfigController::calculate_invoice_balance_before($invoice_id)+abs($amount);
		        $transaction->save();

		       	//Change account balance for the client 
		        $client = Client::find($client_id);

		        if($invoice_type == 'Normal')
		        {
		        	$client->balance = $client->balance + abs($amount);
		        }

		        if($invoice_type == 'Training')
		        {
		        	$client->training_balance = $client->training_balance + abs($amount);
		        }

		        $client->save();
		    	

				break;

			case '2'://partial payment
				$transaction = new Transaction;
				$transaction->invoice_id = $invoice_id;
				$transaction->brand_id = '5';
				$transaction->amount = -$amount;
				$transaction->client_id = $client_id;
				$transaction->reference_transaction_id = $id;
				$transaction->status = $status;
				$transaction->created_by = Auth::user()->id;
				$transaction->note = 'Partial Payment Reversal';
				$transaction->reference_number = $invoice_ref;	
				$transaction->bal_before = ConfigController::get_Client_Bal($client_id,$invoice_type);
		        $transaction->bal_after = ConfigController::get_Client_Bal($client_id,$invoice_type)-$amount;
		        $transaction->invoice_bal_before = ConfigController::calculate_invoice_balance_before($invoice_id);
		        $transaction->invoice_bal_after = ConfigController::calculate_invoice_balance_before($invoice_id)-$amount;
		        $transaction->save();

		       	//Change account balance for the client 
		        $client = Client::find($client_id);

		        if($invoice_type == 'Normal')
		        {
		        	$client->balance = $client->balance - $amount;
		        }

		        if($invoice_type == 'Training')
		        {
		        	$client->training_balance = $client->training_balance - $amount;
		        }

		        $client->save();
				break;

			case '3'://full payment
				$transaction = new Transaction;
				$transaction->invoice_id = $invoice_id;
				$transaction->brand_id = '6';
				$transaction->amount = -$amount;
				$transaction->client_id = $client_id;
				$transaction->reference_transaction_id = $id;
				$transaction->status = $status;
				$transaction->created_by = Auth::user()->id;
				$transaction->note = 'Full Payment Reversal';
				$transaction->reference_number = $invoice_ref;	
				$transaction->bal_before = ConfigController::get_Client_Bal($client_id,$invoice_type);
		        $transaction->bal_after = ConfigController::get_Client_Bal($client_id,$invoice_type)-$amount;
		        $transaction->invoice_bal_before = ConfigController::calculate_invoice_balance_before($invoice_id);
		        $transaction->invoice_bal_after = ConfigController::calculate_invoice_balance_before($invoice_id)-$amount;
		        $transaction->save();

		       	//Change account balance for the client 
		        $client = Client::find($client_id);

		        if($invoice_type == 'Normal')
		        {
		        	$client->balance = $client->balance - $amount;
		        }

		        if($invoice_type == 'Training')
		        {
		        	$client->training_balance = $client->training_balance - $amount;
		        }

		        $client->save();
				break;
		}
	}


	public static function create_transaction($invoice_id,$brand_id,$total_amount,$client_id,$created_by,$note,$reference_transaction_id,$status,$filename,$reference_number,$amount_paid,$invoice_type,$payment_type,$payment_count,$payment_type1,$payment_type2,$payment_type3,$payment_amount1,$payment_amount2,$payment_amount3){

		switch ($brand_id) {
			case '1'://Raise Invoice
		        $transaction = new Transaction;
		        $transaction->invoice_id = $invoice_id;
		        $transaction->brand_id = $brand_id;
		        $transaction->amount = -$total_amount;
		        $transaction->client_id = $client_id;
		        $transaction->bal_before = ConfigController::get_Client_Bal($client_id,$invoice_type);
		        $transaction->bal_after = ConfigController::get_Client_Bal($client_id,$invoice_type)-$total_amount;
		        $transaction->invoice_bal_before = 0;
		        $transaction->invoice_bal_after = 0-$total_amount;
		        $transaction->created_by = $created_by;
		        $transaction->note = $note;
		        $transaction->reference_transaction_id = $reference_transaction_id;
		        $transaction->status = $status;
		        $transaction->filename = $filename;
		        $transaction->reference_number = $reference_number;
		        $transaction->payment_type = 'Other';
		        $transaction->save();


		        //Change account balance for the client 
		        $client = Client::find($client_id);

		        if($invoice_type == 'Normal')
		        {
		        	$client->balance = $client->balance - $total_amount;
		        }

		        if($invoice_type == 'Training')
		        {
		        	$client->training_balance = $client->training_balance - $total_amount;
		        }

		        $client->save();
				break;
			
			case '2'://Partial Payment		

				$transaction = new Transaction;
		        $transaction->invoice_id = $invoice_id;
		        $transaction->brand_id = $brand_id;
		        $transaction->amount = $amount_paid;
		        $transaction->client_id = $client_id;
		        $transaction->bal_before = ConfigController::get_Client_Bal($client_id,$invoice_type);
		        $transaction->bal_after = ConfigController::get_Client_Bal($client_id,$invoice_type)+$amount_paid;
		        $transaction->invoice_bal_before = ConfigController::calculate_invoice_balance_before($invoice_id);
		        $transaction->invoice_bal_after = ConfigController::calculate_invoice_balance_before($invoice_id)+$amount_paid;
		        $transaction->created_by = $created_by;
		        $transaction->note = $note;
		        $transaction->reference_transaction_id = $reference_transaction_id;
		        $transaction->status = $status;
		        $transaction->filename = $filename;
		        $transaction->reference_number = $reference_number;
		        $transaction->payment_type = $payment_type; 
                $transaction->payment_count = $payment_count; 
                $transaction->payment_type1 = $payment_type1; 
                $transaction->payment_type2 = $payment_type2; 
                $transaction->payment_type3 = $payment_type3; 
                $transaction->payment_amount1 = $payment_amount1; 
                $transaction->payment_amount2 = $payment_amount2; 
                $transaction->payment_amount3 = $payment_amount3; 
		        $transaction->save();	

		        /*
		        Change account balance for the client 
				Example:
				---------
				raise invoice of $10 will make then balance less by 10. So bal will be -10
				Now when the client pays $5 as a partial amount then increase the value by 5
				so bal remains is now -5.	
		        */

		        $client = Client::find($client_id);
		        if($invoice_type == 'Normal')
		        {
		        	$client->balance = $client->balance + $amount_paid;
		        }

		        if($invoice_type == 'Training')
		        {
		        	$client->training_balance = $client->training_balance + $amount_paid;
		        }

		        $client->save();


		        $check_remain = ConfigController::calculate_invoice_balance_before($invoice_id);

		        if($check_remain == 0)
		        {
		        	$invoice = Invoice::find($invoice_id);
		        	$invoice->status = 'p';
		        	$invoice->save();
		        }
			    
				break;


				case '3': //Full Payment
					$transaction = new Transaction;
			        $transaction->invoice_id = $invoice_id;
			        $transaction->brand_id = $brand_id;
			        $transaction->amount = $amount_paid;
			        $transaction->client_id = $client_id;
			        $transaction->bal_before = ConfigController::get_Client_Bal($client_id,$invoice_type);
			        $transaction->bal_after = ConfigController::get_Client_Bal($client_id,$invoice_type)+$amount_paid;
			        $transaction->invoice_bal_before = ConfigController::calculate_invoice_balance_before($invoice_id);
			        $transaction->invoice_bal_after = ConfigController::calculate_invoice_balance_before($invoice_id)+$amount_paid;
			        $transaction->created_by = $created_by;
			        $transaction->note = $note;
			        $transaction->reference_transaction_id = $reference_transaction_id;
			        $transaction->status = $status;
			        $transaction->filename = $filename;
			        $transaction->reference_number = $reference_number;
			        $transaction->payment_type = $payment_type; 
	                $transaction->payment_count = $payment_count; 
	                $transaction->payment_type1 = $payment_type1; 
	                $transaction->payment_type2 = $payment_type2; 
	                $transaction->payment_type3 = $payment_type3; 
	                $transaction->payment_amount1 = $payment_amount1; 
	                $transaction->payment_amount2 = $payment_amount2; 
	                $transaction->payment_amount3 = $payment_amount3; 
			        $transaction->save();	

			        $client = Client::find($client_id);
			        if($invoice_type == 'Normal')
			        {
			        	$client->balance = $client->balance + $amount_paid;
			        }

			        if($invoice_type == 'Training')
			        {
			        	$client->training_balance = $client->training_balance + $amount_paid;
			        }

			        $client->save();

					break;
		}

    }





    public static function calculate_invoice_balance_before($invoice_id)
    {
    	//get transactions under invoice passed
    	$transactions = Transaction::where('invoice_id',$invoice_id)->get();

    	if(count($transactions) <> 0)
    	{
    		$amount = 0;
    		foreach ($transactions as $transaction) {
    			$amount = $amount + $transaction->amount;
    		}

    		return $amount;
    	}
    	else
    	{
    		$amount = 0;
    		return $amount;
    	}
    }


    public static function get_Client_Bal($id,$invoice_type)
    {
    	$client = Client::withTrashed()->find($id);
    	if($invoice_type == 'Normal')
    	{
    		return $client->balance;
    	}
    	if($invoice_type == 'Training')
    	{
    		return $client->training_balance;
    	}
    }


    public static function print_invoice_status($status){
    	switch ($status) {
    		case 'e':
    			return 'Expire';
    			break;
    		case 'o':
    			return 'Overdue';
    			break;
    		case 'u':
    			return 'Unpaid';
    			break;

    		case 'pp':
    			return 'Partial Paid';
    			break;

    		case 'p':
    			return 'Paid';
    			break;

    		default:
    			# code...
    			break;
    	}
    }


    public static function get_b2b($id)
    {
    	if($id <> '')
    	{
    		$client = Client::find($id);
    		return $client->tin_number;
    	}
    	else
    	{
    		return '';
    	}
    }


    public static function items_breakdown_json($id,$amount)
    {
    	$charges = Charge::where('invoice_id',$id)->get();
    	
    	$value = '';
    	$count = 1;

    	$charges_count = count($charges);

	    	if(count($charges)>0)
	    	{
	    		foreach ($charges as $charge) 
	    		{
	    			$value .= '{
	                                "GTIN": null,
	                                "Name": "'.ConfigController::get_product_name($charge->product_id).'",
	                                "Quantity": '.$charge->quantity.',
	                                "UnitPrice":'.$charge->amount.',
	                                "Labels": 
	                                    '.ConfigController::get_product_labels($charge->product_id).'
	                                ,
	                                "TotalAmount": '.$charge->amount * $charge->quantity.'
	                            }';
	                if($count <> $charges_count)
	                {
	                	$value .= ',';
	                }

	                $count++;
	    		}
	    	}

    	echo $value;

    }


    public static function get_product_labels($product_id)
    {
    	$product =  Product::withTrashed()->find($product_id);
    	return $product->labels;
    }


    public static function get_product_name($product_id)
    {
    	$product =  Product::withTrashed()->find($product_id);
    	return $product->name;
    }


    public static function get_uuid_invoice($transaction_type,$invoice_type,$invoice_id)
    {

    	switch ($invoice_type) {
    		case 'Normal':
    			$var = 'NM-';
    			break;
    		
    		case 'Training':
    			$var = 'TR-';
    			break;

    		case 'Copy':
    			$var = 'CP-';
    			break;

    		case 'ProForma':
    			$var = 'PF-';
    			break;
    	}


    	switch ($transaction_type) {
    		case 'Sale':
    			$var = $var.'SALE-';
    			break;
    		
    		case 'Refund':
    			$var = $var.'REFUND-';
    			break;
    	}

    	$var = $var.$invoice_id;

    	return $var;
    }


    public static function get_product_price($product_id)
    {
    	$product = Product::withTrashed()->find($product_id);
    	return $product->amount;
    }

    public static function get_product_desc($product_id)
    {
    	$product = Product::withTrashed()->find($product_id);
    	return $product->description;
    }


    public static function determine_payment_type($invoice_id)
    {
    	$invoice = Invoice::find($invoice_id);

    	$payment_type = '';

    	switch ($invoice->status) 
    	{
    		case 'u'://unpaid
    			$payment_type = 'Other';
    			break;

    		case 'pp'://partial
    			$payment_type = 'Other';
    			break;

    		case 'p'://paid
    			$payment_type = $invoice->payment_type;
    			break;    			
       	}


       	if($invoice->payment_type == 'SplitPayment') 
    	{
    		$payment_type = 'Other';			    			
       	}


       	return $payment_type;
    }

    public static function get_brand_name($brand_id)
    {
    	$brand = Brand::withTrashed()->find($brand_id);

    	return $brand->name;
    }


    public static function get_invoice_balance($id)
    {
    	$transaction_bal = Transaction::where('invoice_id',$id)->sum('amount');
    	return $transaction_bal;
    }

    public static function get_fiscal_status($id)
    {
    	//THIS IS NOT A FISCAL RECEIPT

    	//FISCAL INVOICE
    	$invoice =  Invoice::find($id);



    	if($invoice->invoice_type == 'Normal')
    	{
    		return '============ FISCAL INVOICE ============';
    	}
    	else
    	{
    		return '===== THIS IS NOT A FISCAL RECEIPT =====';
    	}

    }


    public static function get_fiscal_status_end($id)
    {
    	$invoice = Invoice::find($id);

    	if($invoice->invoice_type == 'Normal')
    	{
    		return '======== END OF FISCAL INVOICE =========';
    	}
    	else
    	{
    		return '===== THIS IS NOT A FISCAL RECEIPT =====';
    	}    	
    }

    public static function get_invoice_status($id)
    {
    	$invoice =  Invoice::find($id);

    	return ' === '.strtoupper($invoice->invoice_type).' '.strtoupper($invoice->transaction_type).' === ';
    }

    public static function get_frcs_status($status)
    {
    	switch ($status) {
    		case '1':
    			return '<span class="btn btn-sm btn-success">Verified</span>';
    			break;

    		case '0':
    			return '<span class="btn btn-sm btn-danger">Not Verified</span>';
    			break;

			case 'x':
				return '<span class="btn btn-sm btn-warning">DOUBT</span>';
				break;
    		default:
    			# code...
    			break;
    	}
    }


    public static function get_sdc_ref($id)
    {
    	$invoice = Invoice::find($id);
    	return $invoice->sdc_invoice_no;
    }

    public static function get_uuid($id)
    {
    	$invoice = Invoice::find($id);
    	return $invoice->uuid;    	
    }


    public static function check_proforma_invoice($invoice_type,$id)
    {
    	$invoice = Invoice::where('invoice_type',$invoice_type)->where('payee_reference',$id)->count();

    	if($invoice == 0)
    	{
    		return true;
    	}
    	else
    	{
    		return false;
    	}
    }

    public static function convert_date($date)
    {
    	$make_date = str_replace('/', '-', $date);
        $date = date_create($make_date);
        $updated_at = date_format($date,"d-m-Y H:i:s");//2019-05-19 15:47:47
        return $updated_at;
    }

    public static function two_decimal($value)
    {
    	$data = number_format((float)$value, 2, '.', ''); 
    	return $data;
    }


    public static function get_userTIN($user_id)
    {
    	if($user_id == '')
    	{
    		return '';
    	}
    	if($user_id == 'CLI')
    	{
    		return '';
    	}
    	else
    	{
    		$user = User::find($user_id);
    		return $user->tin_number;
    	}
    }
}



