<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Client;
use Auth;
use Log;
/*
=====================================
This class is used to list add and edit client information
Privilege used in this class are as follows 
ACCESS_CLIENT_VIEW - Access to View clients
ACCESS_ADD_CLIENT - Access to Add Clients
ACCESS_EDIT_LICENCE - Access to Edit Clients
ACCESS_LICENCE_DELETE - Access to Delete Clients

=====================================
*/

class ClientController extends Controller
{
	public function __construct(){
		$this->middleware('auth');
	}

	public function view_client(Request $request)
	{
		if(ConfigController::check_privilege('ACCESS_CLIENT_VIEW'))
	    {
			$clients = Client::withTrashed()->get();

			if($request->ajax()) 
            {
                $view = view('clients.data',compact('clients'))->render();

                return response()->json(['html'=>$view]);
            }

			return view('clients.list',compact('clients'));
	    }
	    else
	    {
	        return view('errors.not_authorized');
	    }
	}


	public function add_client(Request $request)
	{
	    if(ConfigController::check_privilege('ACCESS_ADD_CLIENT'))
	    {
	    	$this->validate($request,[
	    			'business_name'   	  =>		'required',
	    			'address'   		  =>		'required',
	    			'phone_contact'   	  =>		'required',
	    			'email'  	 		  =>		'required',
	    			'tin_number'   		  =>		'required',
	    			'contact_name'   	  =>		'required'
	    		]);

	    	try
	    	{

	    		$client = new Client;
				$client->business_name 			= $request->business_name;
				$client->address 	   			= $request->address;
				$client->phone_contact 			= $request->phone_contact;
				$client->email 		   			= $request->email;
				$client->tin_number    			= $request->tin_number;
				$client->balance       			= 0;
				$client->training_balance       = 0;
				$client->contact_name  			= $request->contact_name;
				$client->updated_by    			= Auth::user()->id;
				$client->created_by    			= Auth::user()->id;
				$client->save();

				return response()->json(['success'=>'Client added successfully.']);

	    	}
	    	catch(\Exception $e)
	    	{
	    		Log::ERROR('=============ADD CLIENT ERROR ================');
	    		Log::ERROR($e);
	    		Log::ERROR('=============ADD CLIENT ERROR END ================');
	    		return response()->json(['error'=>'Sorry, Something went wrong. Please contact Admin.']);
	    	}

	    }
	    else
	    {
			return response()->json(['error'=>'Sorry, you do not have access to this service. Please contact Admin.']);
	    }
	}


	public function edit_client(Request $request)
	{
	    if(ConfigController::check_privilege('ACCESS_EDIT_CLIENT'))
	    {
	    	$this->validate($request,[
	    			'business_name'   	  =>		'required',
	    			'address'   		  =>		'required',
	    			'phone_contact'   	  =>		'required',
	    			'email'  	 		  =>		'required',
	    			'tin_number'   		  =>		'required',
	    			'contact_name'   	  =>		'required'					
	    		]);

	    	try
	    	{

	    		$client = Client::find($request->id);
				$client->business_name = $request->business_name;
				$client->address 	   = $request->address;
				$client->phone_contact = $request->phone_contact;
				$client->email 		   = $request->email;
				$client->tin_number    = $request->tin_number;
				$client->contact_name  = $request->contact_name;
				$client->updated_by = Auth::user()->id;
				$client->save();

				return response()->json(['success'=>'Client edited successfully.']);

	    	}
	    	catch(\Exception $e)
	    	{
	    		Log::ERROR('=============EDIT Client ERROR ================');
	    		Log::ERROR($e);
	    		Log::ERROR('=============EDIT Client ERROR END ================');
	    		return response()->json(['error'=>'Sorry, Something went wrong. Please contact Admin.']);
	    	}

	    }
	    else
	    {
			return response()->json(['error'=>'Sorry, you do not have access to this service. Please contact Admin.']);
	    }
	}



	public function delete_client(Request $request)
	{
	    if(ConfigController::check_privilege('ACCESS_DELETE_CLIENT'))
	    {

	    	try
	    	{

	    		$client = Client::find($request->id);
				$client->updated_by = Auth::user()->id;
				$client->save();//update
				$client->delete();//delete

				return response()->json(['success'=>'Client Deleted successfully.']);

	    	}
	    	catch(\Exception $e)
	    	{
	    		Log::ERROR('=============Delete CLIENT ERROR ================');
	    		Log::ERROR($e);
	    		Log::ERROR('=============Delete CLIENT ERROR END ================');
	    		return response()->json(['error'=>'Sorry, Something went wrong. Please contact Admin.']);
	    	}

	    }
	    else
	    {
			return response()->json(['error'=>'Sorry, you do not have access to this service. Please contact Admin.']);
	    }
	}


	public function restore_client(Request $request)
	{
	    if(ConfigController::check_privilege('ACCESS_RESTORE_CLIENT'))
	    {

	    	try
	    	{
	    		$client = Client::withTrashed()->find($request->id);
				$client->updated_by = Auth::user()->id;
				$client->save();//update
				$client->restore();//restore

				return response()->json(['success'=>'Client Restore successfully.']);

	    	}
	    	catch(\Exception $e)
	    	{
	    		Log::ERROR('=============Restore CLIENT ERROR ================');
	    		Log::ERROR($e);
	    		Log::ERROR('=============Restore CLIENT ERROR END ================');
	    		return response()->json(['error'=>'Sorry, Something went wrong. Please contact Admin.']);
	    	}

	    }
	    else
	    {
			return response()->json(['error'=>'Sorry, you do not have access to this service. Please contact Admin.']);
	    }
	}

}
