<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Brand;
use Auth;

class BrandController extends Controller
{


/*
PRIVILEGES USED
===================
ACCESS_ADD_BRAND
ACCESS_LIST_BRAND
ACCESS_EDIT_BRAND
ACCESS_DELETE_BRAND
ACCESS_RESTORE_BRAND
ACCESS_SEARCH_BRAND

*/
	public function __construct(){
		$this->middleware('auth');
	}

    public function add_brands(){
    	if(ConfigController::check_privilege('ACCESS_ADD_BRAND'))
    	{
    		return view('brands.add');
    	}
    	else
    	{
    		return view('errors.not_authorized');
    	}
    }

    public function save_brands(Request $request){
    	if(ConfigController::check_privilege('ACCESS_ADD_BRAND'))
    	{

    		
    		$this->validate($request,[
    			'name' => 'required',
                'description' => 'required',
    		]);


    		Brand::create([
    			'name' => $request->name,
    			'description' => $request->description,
    			'created_by' => Auth::user()->id,
    			'updated_by' => Auth::user()->id

    		]);

    		return response()->json(['message' => 'Brand Name: '.$request->name.' has been added.']);
    	}
    	else
    	{
    		return view('errors.not_authorized');
    	} 	
    }


    public function list_brands(){
    	if(ConfigController::check_privilege('ACCESS_LIST_BRAND'))
    	{
    		$brands = Brand::all();

    		return view('brands.list',compact('brands'));
    	}
    	else
    	{
    		return view('errors.not_authorized');
    	}    	

    }


    public function edit_brands($id){

    	if(ConfigController::check_privilege('ACCESS_EDIT_BRAND'))
    	{
	    	$brands  = Brand::where('id',$id)->get();

    	}
    	else
    	{
    		return view('errors.not_authorized');
    	}    

    	return view('brands.edit',compact('brands','id'));

    }

    public function update_brands(Request $request){
    	if(ConfigController::check_privilege('ACCESS_EDIT_BRAND'))
    	{

    		$this->validate($request,[
    			'name' 			=> 'required',
                'description' 	=> 'required',
    		]);

	    	$brands = Brand::find($request->id);
	    	$brands->name = $request->name;
            $brands->description = $request->description;
	    	$brands->updated_by = Auth::user()->id;
	    	$brands->save();

            return response()->json(['message' => 'Brand has been updated']);
	    }
	    else
	    {
	    	return view('errors.not_authorized');
	    }

    	return response()->json(['message' => 'Brand has been updated.']);
    }


    public function delete_brands(Request $request){
    	if(ConfigController::check_privilege('ACCESS_DELETE_BRAND'))
    	{
	    	$brands = Brand::find($request->id);
	    	$brands->updated_by = Auth::user()->id;
	    	$brands->save();
	    	$brands->delete();
	    }
	    else
	    {
	    	return view('errors.not_authorized');
	    }

	    return response()->json(['success']);

    }


    public function restore_brands_list(){
    	if(ConfigController::check_privilege('ACCESS_RESTORE_BRAND')){
    		$brands = Brand::onlyTrashed()->get();

    		return view('brands.restore_list',compact('brands'));
    	}
    	else
    	{
    		return view('errors.not_authorized');
    	}
    }

    public function restore_brand(Request $request){
    	if(ConfigController::check_privilege('ACCESS_RESTORE_BRAND'))
    	{
    		Brand::onlyTrashed()->find($request->id)->restore();

    		return response()->json(['success']);
    	}
    	else
    	{
    		return response()->json(['error']);
    	}
    }


    public function brands_search(Request $request){
    	if(ConfigController::check_privilege('ACCESS_SEARCH_BRAND'))
    	{
    		$brands = Brand::where('name','like','%'.$request->name.'%')->get();

    		return view('brands.list',compact('brands'));
    	}
    	else
    	{
    		return view('errors.not_authorized');
    	}
    }


    


}
