<?php

namespace App\Http\Controllers;

	use Illuminate\Http\Request;
    use Illuminate\Support\Facades\Log;
class APILoginController extends Controller
{
    public function __construct()
    {
        $this->log = Log::channel('app');

        $this->middleware('APIkey');

    }
    //Please add this method
    public function login(Request $request) {
        // get email and password from request
        $request->validate([
            'email'   => 'required',
            'password'  => 'required'
        ]);

        $credentials = request(['email', 'password']);
        
        // try to auth and get the token using api authentication
        if (!$token = auth('api')->attempt($credentials)) {
        	$this->log->error('Login Failed for email '.request('email'));
            // if the credentials are wrong we send an unauthorized error in json format
            return response()->json(['error' => 'Unauthorized'], 401);
        }
        $this->log->info('Login successful for email '.request('email'));
        return response()->json([
            'email' => request('email'),
            'status' => '200',
            'token' => $token,
            'type' => 'bearer', // you can ommit this
            'expires' => auth('api')->factory()->getTTL() * 60, // time to expiration
            
        ]);
    }
}
