<?php

namespace App\Http\Controllers;

    use App\Http\Controllers\Controller;
    use Illuminate\Support\Facades\Auth;
    use App\User;
    use Response;
    use Carbon\Carbon;
    use DB;
    use Illuminate\Support\Facades\Log;
    use App\Privilege_Mapping;
	use Illuminate\Http\Request;

class APIAPPController extends Controller
{
        protected $log;
        protected $user;
        public function __construct()
        {
            $this->log = Log::channel('app');

            // $this->middleware('APIkey');
            $this->middleware('jwt.auth');
            $this->user = auth('api')->user();
            $this->content = array();
        }

        function user() {
        	$this->log->info('User requested for user details => '.$this->user->email);
    		return auth('api')->user();
		}

		function get_status()
		{
			if($this->user->id <> null)
			{
				return response()->json(['data' => 0]);
			}
			else
			{
				return response()->json(['data' => 1]);
			}
		}

		function menus()
		{
			if($this->user->id <> null)
			{

				$menus ='';

				//Invoices 
				if(APIAPPController::check_privilege_app('ACCESS_VIEW_INVOICE'))
				{
					$menus.='<li><a href="/invoices/" class="panel-close">Invoices</a></li>';
				}

				//Invoices 
				if(APIAPPController::check_privilege_app('ACCESS_CLIENT_VIEW'))
				{
					$menus.='<li><a href="/clients/" class="panel-close">Clients</a></li>';
				}

				$menus.='<li><a href="#" onclick="load_menus();" class="panel-close">Reload Menus</a></li>';

				return response()->json(['data' => 0,'menus' => $menus]);

			}
			else
			{
				return response()->json(['data' => 1]);
			}
		}

		function logout()
		{
			// Pass true to force the token to be blacklisted "forever"
			try
			{
				auth('api')->logout(true);
				$this->log->info('Logged out user '. $this->user->email);
				return response()->json(['data' => 0]);
			}
			catch(\Exception $e)
			{
				$this->log->error('Error logging out user '.$this->user->email);
				$this->log->debug($e);
				return response()->json(['data' => 1]);
			}
		}


		static function check_privilege_app($privilege_name){
			// $this->log->info('Checking privileges for user email '.auth('api')->user()->email);
			$role_id = auth('api')->user()->role_id;
			// $privileges = DB::table('view_users_mapping')->where('role_id',$role_id)
			// 											 ->where('name', $privilege_name)
			// 											 ->get();

			$privileges = DB::table('privileges_mapping  AS r')
							->join('privileges AS p', 'p.id', '=', 'r.privilege_id')
							->where('r.role_id',$role_id)
							->where('p.name',$privilege_name)
							->where('r.deleted_at',null)
							->get();



			if(count($privileges) == 1)
			{
				return true;
			}
			else
			{
				return false;
			}
		}

}

