<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Invoice;
use App\Client;
use App\Charge;
use App\Tax;
use App\Email;
use App\Transaction;
use PDF;
use Mail;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\ConfigController;

class send_invoice_email extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'send_invoice_email';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sends email to Customer and owner with invoice';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        //get invoices for which email needs to be sent
        Log::channel('send_invoice_email')->info('===================== START RAISE INVOICE SCHEDULER ========================');
        
        $invoices = Invoice::where('send_email','y')
                             ->get();

        Log::channel('send_invoice_email')->info('Found '.count($invoices).' invoices');

        if(count($invoices) > 0)//if have data
        {
            foreach ($invoices as $invoice) 
            {
                Log::channel('send_invoice_email')->info('Working on invoice # '.$invoice->uuid.'. Invoice Type:'.$invoice->invoice_type);
                
                //PDF Starts
                $invoice_type = $invoice->invoice_type;
                $status = $invoice->status;
                $url = $invoice->url;
                $transaction_type = $invoice->transaction_type;
                $total_amount = $invoice->total_amount;
                $due_date = $invoice->due_date;
                $payment_type = $invoice->payment_type;
                $status = $invoice->status;
                $client_id = $invoice->client_id;
                $client = Client::find($client_id);
                $created_at = $invoice->created_at;
                $updated_at = $invoice->updated_at;
                $sdc_time = $invoice->sdc_time;
                $sdc_invoice_no = $invoice->sdc_invoice_no;
                $invoice_counter = $invoice->invoice_counter;

                $taxs = Tax::where('invoice_id', $invoice->id)->get();

                $charges = Charge::where('invoice_id', $invoice->id)->get();

                $transactions = Transaction::where('invoice_id',$invoice->id)->get();

                $transaction_bal = Transaction::where('invoice_id',$invoice->id)->sum('amount');

                

                //email body data
                $data = array(
                            'invoice_type'  => $invoice_type,
                            'status'  => $status,
                            'url'  => $url,
                            'transaction_type'  => $transaction_type,
                            'total_amount'  => $total_amount,
                            'due_date'  => $due_date,
                            'payment_type'  => $payment_type,
                            'client'  => $client,
                            'created_at'  => $created_at,
                            'updated_at'  => $updated_at,
                            'taxs'  => $taxs,
                            'sdc_time'  => $sdc_time,
                            'sdc_invoice_no'  => $sdc_invoice_no,
                            'invoice_counter'  => $invoice_counter,
                            'invoice'  => $invoice,
                            'charges'  => $charges,
                            'transaction_bal'  => $transaction_bal,
                            'transactions'  => $transactions,

                            );

                 $pdf = PDF::loadView('pdf.frcs',array('data'=>$data));
                 //PDF ends

                //get Client Email Address
                $client = Client::find($invoice->client_id);
                $email = $client->email;

                Log::channel('send_invoice_email')->info('Sending email to '.$email);

                try{

                        $emails_data = array(   
                                            'email' => $email,
                                            'name' => $client->contact_name,
                                            'id' => $invoice->uuid,
                                            'cc_name' => config('app.name'),
                                            'cc_email'=> config('app.email')
                                        );


                        Mail::send('emails.unpaid', array('data'=>$data), function($message) use ($emails_data,$pdf)
                        {    
                            $message->to($emails_data['email'],$emails_data['name'])
                                    ->cc($emails_data['cc_email'],$emails_data['cc_name'])
                                    ->subject('Customer Invoice #'.$emails_data['id'])
                                    ->attachData($pdf->output(), "Customer Invoice #".$emails_data['id'].".pdf");    
                        });

                        $status_email = false;

                }
                catch(\Exception $e)
                {
                        $email = new Email;
                        $email->type = 'Invoice';
                        $email->type_id = $invoice->id;
                        $email->name = 'Raise Invoice';
                        $email->sent = 'n';
                        $email->save();

                        Log::channel('send_invoice_email')->ERROR('Email not sent for invoice ID '.$invoice->uuid);
                        Log::channel('send_invoice_email')->ERROR($e);
                        Log::channel('send_invoice_email')->ERROR('END ERROR LOGS for Invoice ID '.$invoice->uuid);

                        $status_email = true;
                }

                if($status_email == false){

                    $email = new Email;
                    $email->type = 'Invoice';
                    $email->type_id = $invoice->id;
                    $email->name = 'Raise Invoice';
                    $email->sent = 'y';
                    $email->save();

                    $update_invoice = '';
                    $update_invoice = Invoice::find($invoice->id);
                    $update_invoice->send_email = '';
                    $update_invoice->save();
                }

                    //EMAIL SENDING FINISHES
            
            }//foreach ends here

        }
        else
        {
             Log::channel('send_invoice_email')->info('No Records found.');
        }


        Log::channel('send_invoice_email')->info('===================== END RAISE INVOICE SCHEDULER ========================');
        Log::channel('send_invoice_email')->info('');
        Log::channel('send_invoice_email')->info('');
    }
}
