<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Subscription;
use App\Client;
use App\Invoice;
use App\Charge;
use App\Email;
use App\Transaction;
use PDF;
use Mail;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\ConfigController;
use App\Http\Controllers\EmailController;
use App\User;
use App\Notifications\NotifyAdminInvoice;

class raise_subscription_invoices extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'raise_subscription_invoices';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'To raise invoices for the invoices for subscriptions';

    /**
     * Create a new command instance.
     *
     * @return void
     */
//Send email for new invoice is missing

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        Log::channel('cron_raise_invoice')->info('===================== START RAISE INVOICE SCHEDULER ========================');
        // Get all Clients
        
        $clients = Client::all();

        foreach ($clients as $client) 
        {
            Log::channel('cron_raise_invoice')->INFO('Working on Client #'.$client->id.' => '.$client->business_name);
            // Assign todays date
            $today = date('Y-m-d');

            //Add 10 days to todays date so that you can raise unpaid invoice 10 days earlier 
            $next_payment = date('Y-m-d', strtotime($today. ' +10 day'));
            //$next_payment = $today;

            $subscriptions = Subscription::where('client_id',$client->id)
                                         ->where('next_payment',$next_payment)
                                         ->get();
            $subscriptions_total = Subscription::where('client_id',$client->id)
                                         ->where('next_payment',$next_payment)
                                         ->sum('amount');
            
            if(count($subscriptions)>0)
            {
                Log::channel('cron_raise_invoice')->INFO('Found invoices that needs to be raised');
                
                    //Create new invoice 
                    $invoice = new Invoice;
                    $invoice->uuid = 'temp_CLI_'.rand();
                    $invoice->client_id = $client->id;
                    $invoice->pos_time = date('Y-m-d H:i:s');
                    $invoice->due_date = $next_payment;
                    $invoice->transaction_type = 'Sale';
                    $invoice->status = 'u';
                    $invoice->payment_type = 'Other';
                    $invoice->invoice_type = 'Normal';
                    $invoice->frcs_verified = '0';
                    $invoice->created_by = 'CLI';
                    $invoice->total_amount = $subscriptions_total;
                    $invoice->amount_paid = 0;
                    $invoice->save();

                    $uuid = ConfigController::get_uuid_invoice($invoice->transaction_type,$invoice->invoice_type,$invoice->id);

                    $invoice->uuid = $uuid;
                    $invoice->save();

                    Log::channel('cron_raise_invoice')->INFO('Creating Invoice # '.$invoice->uuid);

                    //Load data in Charges table
                    foreach ($subscriptions as $subscription) 
                    {
                        //Adding Charges
                        $charge = new Charge;
                        $charge->client_id = $subscription->client_id;
                        $charge->product_id = $subscription->product_id;
                        $charge->invoice_id = $invoice->id;
                        $charge->quantity = '1';
                        $charge->amount = $subscription->amount;
                        $charge->created_by = 'CLI';
                        $charge->updated_by = 'CLI';
                        $charge->save();

                        //Now change the subscription next payment date and also delete any subscriptions which had zero days
                        if($subscription->next_payment == 0)
                        {
                            $subscription->delete();
                        }
                        else
                        {
                            $new_date = date('Y-m-d', strtotime($subscription->next_payment. ' +'.$subscription->days.' day'));
                            $subscription->next_payment = $new_date;
                            $subscription->updated_by = 'CLI';
                            $subscription->save();
                        }

                    }//End Subscription For Loop

                    //create_transaction($invoice_id,$brand_id,$total_amount,$client_id,$created_by,$note,$reference_transaction_id,$status,$filename,$reference_number,$amount_paid,$invoice_type)
                    //Create a new transaction with brand ID 1 -> Raise Invoice
                    ConfigController::create_transaction($invoice->id,'1',$invoice->total_amount,$client->id,'CLI','Subscription Billing',$ref_transaction_id=null,'a',$filename=null,$reference_number=null,0,$invoice->invoice_type,null,null,null,null,null,null,null,null);
                    


                    //Get charges
                    $charges = Charge::where('invoice_id',$invoice->id)->get();



                    User::find('1')->notify(new NotifyAdminInvoice($invoice));

                    //send email to clients to payup the funds and advise the duedate
                    EmailController::raise_invoice($invoice->id);
                
            }
            else
            {
                Log::channel('cron_raise_invoice')->INFO('No Invoices subscriptions left to be raised');
                Log::channel('cron_raise_invoice')->INFO('---------------------');
            }//End IF statement

        }//End Foreach
        Log::channel('cron_raise_invoice')->INFO('===================== End RAISE INVOICE SCHEDULER ========================');
        Log::channel('cron_raise_invoice')->INFO(' ');
        Log::channel('cron_raise_invoice')->INFO(' ');
    }//End Handle
}//End class
