<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Subscription;
use App\Client;
use App\Invoice;
use App\Charge;
use App\Email;
use App\Transaction;
use PDF;
use Mail;
use Illuminate\Support\Facades\Log;

class ProFormaExpire extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ProFormaExpire';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Cron runs and expires Proforma Invoice after 30days';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        //
        $date = date('Y-m-d', strtotime(now().' -30 day'));
        $status = ['u','pp','p'];

        Log::channel('proforma_cron')->info('');
        Log::channel('proforma_cron')->info('===================== START Proforma Cron ========================');
        Log::channel('proforma_cron')->info('Fetching all Proforma invoices...');

        $invoices = Invoice::whereIn('status',$status)
                           ->where('invoice_type','ProForma') 
                           ->where('transaction_type','Sale') 
                           ->get();

        Log::channel('proforma_cron')->debug($invoices);

        foreach($invoices as $invoice)
        {
            $pos_time = $date = date('Y-m-d', strtotime($invoice->pos_time));
            
            Log::channel('proforma_cron')->info('Working on invoice #'.$invoice->uuid);
            if($pos_time == $date)
            {
                $update = Invoice::find($invoice->id);
                $update->status = 'e';
                $update->save();

                Log::channel('proforma_cron')->info('Updated invoice #'.$invoice->uuid);
            }

        }//end foreach

        Log::channel('proforma_cron')->info('===================== End Proforma Cron ========================');
    }
}
